/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.med.countway.dl.servlet;

import edu.harvard.med.countway.config.CountwayConfig;
import edu.harvard.med.countway.dl.dao.ClassDAO;
import edu.harvard.med.countway.dl.dao.ClassUserDAO;
import edu.harvard.med.countway.dl.model.Class;
import edu.harvard.med.countway.dl.servlet.AbstractServlet;
import edu.harvard.med.countway.tools.IntegerUtil;
import edu.harvard.med.countway.tools.MailUtil;
import edu.harvard.med.countway.tools.TemplateUtil;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public class RegisterServlet
extends AbstractServlet {
    private static final long serialVersionUID = -6624861358513360679L;
    private static final Logger log = Logger.getLogger(RegisterServlet.class);
    private static final String loginUrl = "../../../login.html?url=menuNavigation/libraryServices/classes/register.html";
    private static final String cancelUrl = "../classes.html";
    private static final String jspUrl = "register.jspx";
    private static final String errorUrl = "../../../error.jspx";

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            RegisterServlet.setDummySessionAttributes(request);
            HttpSession session = request.getSession();
            ClassUserDAO classUserDao = new ClassUserDAO();
            ClassDAO classDao = new ClassDAO();
            Integer dluid = (Integer)session.getAttribute("dluid");
            String uid = (String)session.getAttribute("uid");
            String insert = request.getParameter("insert");
            String classId = request.getParameter("classId");
            String firstName = request.getParameter("firstName");
            String lastName = request.getParameter("lastName");
            String affiliation = request.getParameter("affiliation");
            String emailprm = request.getParameter("email");
            String cancel = request.getParameter("cancel");
            ArrayList<String> messages = new ArrayList<String>();
            if (uid == null || uid.trim().equals("")) {
                response.sendRedirect("../../../login.html?url=menuNavigation/libraryServices/classes/register.html?classId=" + classId);
                return;
            }
            if (classId == null || classId.trim().equals("") || !IntegerUtil.isValidInteger((String)classId) || !classDao.classExists(Integer.valueOf(Integer.parseInt(classId))).booleanValue()) {
                messages.add("This class does not exist or is invalid!");
                request.setAttribute("messages", messages);
                request.getRequestDispatcher(jspUrl).forward((ServletRequest)request, (ServletResponse)response);
                return;
            }
            if (cancel != null) {
                response.sendRedirect(cancelUrl);
                return;
            }
            Class clazz = classDao.selectClass(Integer.valueOf(Integer.parseInt(classId)));
            if (classUserDao.classUserExists(clazz.getId(), dluid).booleanValue()) {
                String msg = TemplateUtil.getClassAlreadyRegisteredMsg((String)clazz.getCourse().getTitle(), (Date)clazz.getTime(), (String)clazz.getLocation().getConcat());
                messages.add(msg);
                request.setAttribute("messages", messages);
                request.getRequestDispatcher(jspUrl).forward((ServletRequest)request, (ServletResponse)response);
                return;
            }
            if (insert != null) {
                if (emailprm == null || emailprm.trim().equals("")) {
                    messages.add("E-mail is required");
                    request.setAttribute("messages", messages);
                    request.setAttribute("class", (Object)clazz);
                    request.getRequestDispatcher(jspUrl).forward((ServletRequest)request, (ServletResponse)response);
                    return;
                }
                if (classUserDao.insertClassUser(clazz.getId(), dluid, firstName, lastName, affiliation, emailprm) != null) {
                    String regAction = "registered";
                    if (classUserDao.classUserIsEnrolled(clazz.getId(), dluid).booleanValue()) {
                        regAction = "enrolled";
                    } else if (classUserDao.classUserIsWaitlisted(clazz.getId(), dluid).booleanValue()) {
                        regAction = "waitlisted";
                    }
                    String msg = TemplateUtil.getClassRegisterMsg((String)regAction, (String)clazz.getCourse().getTitle(), (Date)clazz.getTime(), (String)clazz.getLocation().getConcat());
                    messages.add(msg);
                    try {
                        String to = !CountwayConfig.getProperty((CountwayConfig.PropertyKey)CountwayConfig.PropertyKey.DEPLOY_TIER).equals("prod") && !CountwayConfig.getProperty((CountwayConfig.PropertyKey)CountwayConfig.PropertyKey.DEPLOY_TIER).equals("stage") ? CountwayConfig.getProperty((CountwayConfig.PropertyKey)CountwayConfig.PropertyKey.GENERAL_NOTIFICATION_TO_EMAIL) : emailprm;
                        String emailmsg = TemplateUtil.getClassRegisterEmail((String)regAction, (String)clazz.getCourse().getTitle(), (Date)clazz.getTime(), (Integer)clazz.getDuration(), (String)clazz.getLocation().getConcat(), (String)request.getScheme(), (String)request.getServerName());
                        MailUtil.sendMail((String)CountwayConfig.getProperty((CountwayConfig.PropertyKey)CountwayConfig.PropertyKey.CLASS_NOTIFICATION_FROM_EMAIL), (String)to, (String)"Countway Class Registration Notification", (String)emailmsg, (String)CountwayConfig.getProperty((CountwayConfig.PropertyKey)CountwayConfig.PropertyKey.GENERAL_NOTIFICATION_TO_EMAIL));
                        messages.add("A registration confirmation has been e-mailed to: " + to);
                    }
                    catch (IOException e) {
                        messages.add("Error sending registration confirmation e-mail");
                    }
                    request.setAttribute("messages", messages);
                    request.getRequestDispatcher(jspUrl).forward((ServletRequest)request, (ServletResponse)response);
                    return;
                }
                messages.add("Couldn't register you for \"" + clazz.getCourse().getTitle() + "\"");
            }
            request.setAttribute("messages", messages);
            request.setAttribute("class", (Object)clazz);
            request.getRequestDispatcher(jspUrl).forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (SQLException e) {
            request.setAttribute("javax.servlet.error.exception", (Object)e);
            request.setAttribute("javax.servlet.jsp.jspException", (Object)e);
            request.getRequestDispatcher(errorUrl).forward((ServletRequest)request, (ServletResponse)response);
        }
    }
}

