/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.med.countway.dl.servlet;

import edu.harvard.med.countway.dl.dao.ResourceDAO;
import edu.harvard.med.countway.dl.dao.ResourceTypeDAO;
import edu.harvard.med.countway.dl.servlet.AbstractServlet;
import edu.harvard.med.countway.tools.IntegerUtil;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class ResourceServlet
extends AbstractServlet {
    private static final long serialVersionUID = 4490150836552634373L;
    private static final Logger log = Logger.getLogger(ResourceServlet.class);
    private static final String jspUrl = "resource.jspx";
    private static final String errorUrl = "../error.jspx";

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            ResourceDAO resourceDao = new ResourceDAO();
            ResourceTypeDAO resourceTypeDao = new ResourceTypeDAO();
            String id = request.getParameter("id");
            ArrayList<String> messages = new ArrayList<String>();
            if (id == null || id.trim().equals("") || !IntegerUtil.isValidInteger((String)id) || !resourceDao.resourceExists(Integer.valueOf(Integer.parseInt(id))).booleanValue()) {
                messages.add("This resource does not exist or is invalid!");
                request.setAttribute("messages", messages);
            } else {
                request.setAttribute("resource", (Object)resourceDao.selectResource(Integer.valueOf(Integer.parseInt(id))));
                request.setAttribute("resourceTypeList", (Object)resourceTypeDao.selectResourceTypeListByResourceId(Integer.valueOf(Integer.parseInt(id))));
            }
            request.getRequestDispatcher(jspUrl).forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (SQLException e) {
            request.setAttribute("javax.servlet.error.exception", (Object)e);
            request.setAttribute("javax.servlet.jsp.jspException", (Object)e);
            request.getRequestDispatcher(errorUrl).forward((ServletRequest)request, (ServletResponse)response);
        }
    }
}

