package edu.harvard.med.countway.dl.model;

import java.util.Date;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement
@XmlType(propOrder = {"id","clazz","user","created","status","firstName","lastName","affiliation","email"})
public class ClassUser
{
    private Integer id;
    private Class clazz;
    private User user;
    private Date created;
    private Status status;
    private String firstName;
    private String lastName;
    private String affiliation;
    private String email;

    public void setId(Integer id)
    {
        this.id = id;
    }
    @XmlAttribute
    public Integer getId()
    {
        return id;
    }

    public void setClazz(Class clazz)
    {
        this.clazz = clazz;
    }
    @XmlElement(name="class")
    public Class getClazz()
    {
        return clazz;
    }
    
    public void setUser(User user)
    {
        this.user = user;
    }
    public User getUser()
    {
        return user;
    }
    
    public void setCreated(Date created)
    {
        this.created = created;
    }
    public Date getCreated()
    {
        return created;
    }

    public void setStatus(Status status)
    {
        this.status = status;
    }
    public Status getStatus()
    {
        return status;
    }

    public void setFirstName(String firstName)
    {
        this.firstName = firstName;
    }
    public String getFirstName()
    {
        return firstName;
    }

    public void setLastName(String lastName)
    {
        this.lastName = lastName;
    }
    public String getLastName()
    {
        return lastName;
    }

    public void setAffiliation(String affiliation)
    {
        this.affiliation = affiliation;
    }
    public String getAffiliation()
    {
        return affiliation;
    }

    public void setEmail(String email)
    {
        this.email = email;
    }
    public String getEmail()
    {
        return email;
    }
    
    @XmlType(name="")
    public static enum Status
    {
        Enrolled,
        Waitlisted,
        Cancelled
    }
}
