package edu.harvard.med.countway.dl.model;

import java.util.Date;
import java.util.EnumSet;

import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement
@XmlType(propOrder = {"userId","active","future","now","sort"})
public class SelectClassListByUserIdParams extends AbstractPager
{   
    private Integer userId;
    private Boolean active;
    private Boolean future;
    private Date now;
    private Sort sort;
    
    public void setUserId(Integer userId)
    {
        this.userId = userId;
    }
    public Integer getUserId()
    {
        return userId;
    }
    
    public void setActive(Boolean active)
    {
        this.active = active;
    }
    public Boolean getActive()
    {
        return active;
    }
    
    public void setFuture(Boolean future)
    {
        this.future = future;
    }
    public Boolean getFuture()
    {
        return future;
    }
    
    public void setNow(Date now)
    {
        this.now = now;
    }
    public Date getNow()
    {
        return now;
    }
    
    public void setSort(Sort sort)
    {
        this.sort = sort;
    }
    public void setSort(String sort)
    {
        this.sort = Sort.getByValue(sort);
    }
    public Sort getSort()
    {
        return sort;
    }
    
    @XmlType(name="")
    public static enum Sort
    {
        Title("title"),
        Date("date"),
        Location("location");
        
        private final String value;
        
        private Sort(final String value)
        {
            this.value = value;
        }
        
        public String getValue()
        {
            return value;
        }
        
        public String toString()
        {
            return value;
        }
        
        public static Sort fromString(final String value)
        {
            return getByValue(value);
        }
        
        public static Sort getByValue(final String value)
        {
            Sort rv = null;
            for (final Sort sort: EnumSet.allOf(Sort.class))
            {
                if (sort.getValue().equals(value))
                {
                    rv = sort;
                }
            }
            return rv;
        }
    }
}
