package edu.harvard.med.countway.dl.model;

import java.util.EnumSet;
import java.util.List;

import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement
@XmlType(propOrder = {"query","typeId","institutionId","active","sort"})
public class SelectCourseListParams extends AbstractPager
{   
    private String query;
    // these must be arrays to be used in <jsp:setProperty/>
    private Integer[] typeId;
    private Integer[] institutionId;
    private Boolean active;
    private Sort sort;
    
    public void setQuery(final String query)
    {
        this.query = query;
    }
    public String getQuery()
    {
        return query;
    }

    public void setTypeId(final Integer[] typeId)
    {
        this.typeId = typeId;
    }
    public void setTypeId(final List<Integer> typeId)
    {
        this.typeId = typeId.toArray(new Integer[] {});
    }
    @XmlElementWrapper(name="typeIdList")
    public Integer[] getTypeId()
    {
        return typeId;
    }
    
    public void setInstitutionId(final Integer[] institutionId)
    {
        this.institutionId = institutionId;
    }
    public void setInstitutionId(final List<Integer> institutionId)
    {
        this.institutionId = institutionId.toArray(new Integer[] {});
    }
    @XmlElementWrapper(name="institutionIdList")
    public Integer[] getInstitutionId()
    {
        return institutionId;
    }
    
    public void setActive(Boolean active)
    {
        this.active = active;
    }
    public Boolean getActive()
    {
        return active;
    }
    
    public void setSort(Sort sort)
    {
        this.sort = sort;
    }
    public void setSort(String sort)
    {
        this.sort = Sort.getByValue(sort);
    }
    public Sort getSort()
    {
        return sort;
    }
    
    @XmlType(name="")
    public static enum Sort
    {
        Title("title");
        
        private final String value;
        
        private Sort(final String value)
        {
            this.value = value;
        }
        
        public String getValue()
        {
            return value;
        }
        
        public String toString()
        {
            return value;
        }
        
        public static Sort fromString(final String value)
        {
            return getByValue(value);
        }
        
        public static Sort getByValue(final String value)
        {
            Sort rv = null;
            for (final Sort sort: EnumSet.allOf(Sort.class))
            {
                if (sort.getValue().equals(value))
                {
                    rv = sort;
                }
            }
            return rv;
        }
    }
}
