package edu.harvard.med.countway.dl.model;

import java.util.EnumSet;

import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement
@XmlType(propOrder = {"ecid","huid","sort"})
public class SelectEcommonsUserListParams extends AbstractPager
{   
    private String ecid;
    private String huid;
    private Sort sort;
    
    public void setEcid(String ecid)
    {
        this.ecid = ecid;
    }
    public String getEcid()
    {
        return ecid;
    }
    
    public void setHuid(String huid)
    {
        this.huid = huid;
    }
    public String getHuid()
    {
        return huid;
    }
    
    public void setSort(Sort sort)
    {
        this.sort = sort;
    }
    public void setSort(String sort)
    {
        this.sort = Sort.getByValue(sort);
    }
    public Sort getSort()
    {
        return sort;
    }
    
    @XmlType(name="")
    public static enum Sort
    {
        EcommonsId("ecid"),
        HarvardId("huid"),
        LastName("lastName");
        
        private final String value;
        
        private Sort(final String value)
        {
            this.value = value;
        }
        
        public String getValue()
        {
            return value;
        }
        
        public String toString()
        {
            return value;
        }
        
        public static Sort fromString(final String value)
        {
            return getByValue(value);
        }
        
        public static Sort getByValue(final String value)
        {
            Sort rv = null;
            for (final Sort sort: EnumSet.allOf(Sort.class))
            {
                if (sort.getValue().equals(value))
                {
                    rv = sort;
                }
            }
            return rv;
        }
    }
}
