package edu.harvard.med.countway.dl.model;

import java.util.EnumSet;
import java.util.List;

import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement
@XmlType(propOrder = {"query","field","typeId","historical","sort"})
public class SelectResourceListParams extends AbstractPager
{
    private String query;
    private Field field;
    // these must be arrays to be used in <jsp:setProperty/>
    private Integer[] typeId;
    private Boolean historical;
    private Sort sort;
    
    public void setQuery(String query)
    {
        this.query = query;
    }
    public String getQuery()
    {
        return query;
    }
    
    public void setField(final Field field)
    {
        this.field = field;
    }
    public void setField(final String field)
    {
        this.field = Field.getByValue(field);
    }
    public Field getField()
    {
        return field;
    }

    public void setTypeId(final Integer[] typeId)
    {
        this.typeId = typeId;
    }
    public void setTypeId(final List<Integer> typeId)
    {
        this.typeId = typeId.toArray(new Integer[] {});
    }
    @XmlElementWrapper(name="typeIdList")
    public Integer[] getTypeId()
    {
        return typeId;
    }
    
    public void setHistorical(Boolean historical)
    {
        this.historical = historical;
    }
    public Boolean getHistorical()
    {
        return historical;
    }
    
    public void setSort(Sort sort)
    {
        this.sort = sort;
    }
    public void setSort(String sort)
    {
        this.sort = Sort.getByValue(sort);
    }
    public Sort getSort()
    {
        return sort;
    }
    
    @XmlType(name="")
    public static enum Field
    {
        Title("title"),
        TitleIndex("title_idx"),
        Subject("subject"),
        Description("description");
        
        private final String value;
        
        private Field(final String value)
        {
            this.value = value;
        }
        
        public String getValue()
        {
            return value;
        }
        
        public String toString()
        {
            return value;
        }
        
        public static Field fromString(final String value)
        {
            return getByValue(value);
        }
        
        public static Field getByValue(final String value)
        {
            Field rv = null;
            for (final Field field: EnumSet.allOf(Field.class))
            {
                if (field.getValue().equals(value))
                {
                    rv = field;
                }
            }
            return rv;
        }
    }
    
    @XmlType(name="")
    public static enum Sort
    {
        Title("title"),
        Score("score");
        
        private final String value;
        
        private Sort(final String value)
        {
            this.value = value;
        }
        
        public String getValue()
        {
            return value;
        }
        
        public String toString()
        {
            return value;
        }
        
        public static Sort fromString(final String value)
        {
            return getByValue(value);
        }
        
        public static Sort getByValue(final String value)
        {
            Sort rv = null;
            for (final Sort sort: EnumSet.allOf(Sort.class))
            {
                if (sort.getValue().equals(value))
                {
                    rv = sort;
                }
            }
            return rv;
        }
    }
}
