package edu.harvard.med.countway.dl.rest;

import java.sql.SQLException;
import java.util.Date;
import java.util.List;

import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

import org.apache.log4j.Logger;

import edu.harvard.med.countway.dl.dao.ClassDAO;
import edu.harvard.med.countway.dl.model.Class;
import edu.harvard.med.countway.dl.model.ClassList;
import edu.harvard.med.countway.dl.model.SelectClassListParams;

@Path("class")
public class ClassResource
{
    private static final Logger log = Logger.getLogger(ClassResource.class);

    @Context
    UriInfo uriInfo;
    private final ClassDAO dao = new ClassDAO();
    
    @GET
    @Produces({"application/xml", "text/plain"})
    public Response selectClassList(
            @QueryParam("query") final String query,
            @DefaultValue("0") @QueryParam("offset") final Integer offset,
            @QueryParam("courseId") final List<Integer> courseId,
            @QueryParam("institutionId") final List<Integer> institutionId,
            @QueryParam("typeId") final List<Integer> typeId,
            @QueryParam("buildingId") final List<Integer> buildingId,
            @QueryParam("active") final Boolean active,
            @QueryParam("future") final Boolean future,
            @DefaultValue("title") @QueryParam("sort") final SelectClassListParams.Sort sort) throws SQLException
    {
        final SelectClassListParams select = new SelectClassListParams();
        select.setQuery(query);
        select.setOffset(offset);
        select.setCourseId(courseId);
        select.setInstitutionId(institutionId);
        select.setTypeId(typeId);
        select.setBuildingId(buildingId);
        select.setActive(active);
        select.setFuture(future);
        select.setNow(new Date());
        select.setSort(sort);
        final ClassList result = dao.selectClassList(select);
        if (result == null)
        {
            return Utils.getNotFoundResponse("classes not found");
        }
        return Response.ok(result).build();
    }
    
    @GET
    @Path("{id}")
    @Produces({"application/xml", "text/plain"})
    public Response selectClass(@PathParam("id") final Integer id) throws SQLException
    {
        final Class clazz = dao.selectClass(id);
        if (clazz == null)
        {
            return Utils.getNotFoundResponse("class "+id+" not found");
        }
        return Response.ok(clazz).build();
    }
}
