package edu.harvard.med.countway.dl.rest;

import java.sql.SQLException;
import java.util.Date;

import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

import org.apache.log4j.Logger;

import edu.harvard.med.countway.dl.dao.ClassUserDAO;
import edu.harvard.med.countway.dl.model.ClassUser;
import edu.harvard.med.countway.dl.model.ClassUserList;
import edu.harvard.med.countway.dl.model.SelectClassUserListParams;

//TODO: disabled until authenticated access is configured
//@Path("class_user")
public class ClassUserResource
{
    private static final Logger log = Logger.getLogger(ClassUserResource.class);

    @Context
    UriInfo uriInfo;
    private final ClassUserDAO dao = new ClassUserDAO();
    
    @GET
    @Produces({"application/xml", "text/plain"})
    public Response selectClassUserList(
            @DefaultValue("0") @QueryParam("offset") final Integer offset,
            @QueryParam("classId") final Integer classId,
            @QueryParam("userId") final Integer userId,
            @QueryParam("active") final Boolean active,
            @QueryParam("future") final Boolean future,
            @DefaultValue("title") @QueryParam("sort") final SelectClassUserListParams.Sort sort) throws SQLException
    {
        final SelectClassUserListParams select = new SelectClassUserListParams();
        select.setOffset(offset);
        select.setClassId(classId);
        select.setUserId(userId);
        select.setActive(active);
        select.setFuture(future);
        select.setNow(new Date());
        select.setSort(sort);
        final ClassUserList result = dao.selectClassUserList(select);
        if (result == null)
        {
            return Utils.getNotFoundResponse("class users not found");
        }
        return Response.ok(result).build();
    }
    
    @GET
    @Path("{id}")
    @Produces({"application/xml", "text/plain"})
    public Response selectClassUser(@PathParam("id") Integer id) throws SQLException
    {
        ClassUser classUser = dao.selectClassUser(id);
        if (classUser == null)
        {
            return Utils.getNotFoundResponse("class user "+id+" not found");
        }
        return Response.ok(classUser).build();
    }
}
