package edu.harvard.med.countway.dl.rest;

import java.sql.SQLException;

import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

import org.apache.log4j.Logger;

import edu.harvard.med.countway.dl.dao.CourseInstitutionDAO;
import edu.harvard.med.countway.dl.model.CourseInstitution;
import edu.harvard.med.countway.dl.model.CourseInstitutionList;
import edu.harvard.med.countway.dl.model.SelectCourseInstitutionListParams;

@Path("course_institution")
public class CourseInstitutionResource
{
    private static final Logger log = Logger.getLogger(CourseInstitutionResource.class);

    @Context
    UriInfo uriInfo;
    private final CourseInstitutionDAO dao = new CourseInstitutionDAO();
    
    @GET
    @Produces({"application/xml", "text/plain"})
    public Response selectCourseInstitutionList(
            @DefaultValue("0") @QueryParam("offset") final Integer offset,
            @DefaultValue("name") @QueryParam("sort") final SelectCourseInstitutionListParams.Sort sort) throws SQLException
    {
        final SelectCourseInstitutionListParams select = new SelectCourseInstitutionListParams();
        select.setOffset(offset);
        select.setSort(sort);
        final CourseInstitutionList result = dao.selectCourseInstitutionList(select);
        if (result == null)
        {
            return Utils.getNotFoundResponse("course institutions not found");
        }
        return Response.ok(result).build();
    }
    
    @GET
    @Path("{id}")
    @Produces({"application/xml", "text/plain"})
    public Response selectCourseInstitution(@PathParam("id") Integer id) throws SQLException
    {
        CourseInstitution courseInstitution = dao.selectCourseInstitution(id);
        if (courseInstitution == null)
        {
            return Utils.getNotFoundResponse("course institution "+id+" not found");
        }
        return Response.ok(courseInstitution).build();
    }
}
