package edu.harvard.med.countway.dl.rest;

import java.sql.SQLException;
import java.util.List;

import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

import org.apache.log4j.Logger;

import edu.harvard.med.countway.dl.dao.CourseDAO;
import edu.harvard.med.countway.dl.model.Course;
import edu.harvard.med.countway.dl.model.CourseList;
import edu.harvard.med.countway.dl.model.SelectCourseListParams;

@Path("course")
public class CourseResource
{
    private static final Logger log = Logger.getLogger(CourseResource.class);

    @Context
    UriInfo uriInfo;
    private final CourseDAO dao = new CourseDAO();
    
    @GET
    @Produces({"application/xml", "text/plain"})
    public Response selectCourseList(
            @QueryParam("query") final String query,
            @DefaultValue("0") @QueryParam("offset") final Integer offset,
            @QueryParam("typeId") final List<Integer> typeId,
            @QueryParam("institutionId") final List<Integer> institutionId,
            @QueryParam("active") final Boolean active,
            @DefaultValue("title") @QueryParam("sort") final SelectCourseListParams.Sort sort) throws SQLException
    {
        final SelectCourseListParams select = new SelectCourseListParams();
        select.setQuery(query);
        select.setOffset(offset);
        select.setTypeId(typeId);
        select.setInstitutionId(institutionId);
        select.setActive(active);
        select.setSort(sort);
        final CourseList result = dao.selectCourseList(select);
        if (result == null)
        {
            return Utils.getNotFoundResponse("courses not found");
        }
        return Response.ok(result).build();
    }
    
    @GET
    @Path("{id}")
    @Produces({"application/xml", "text/plain"})
    public Response selectCourse(@PathParam("id") final Integer id) throws SQLException
    {
        final Course course = dao.selectCourse(id);
        if (course == null)
        {
            return Utils.getNotFoundResponse("course "+id+" not found");
        }
        return Response.ok(course).build();
    }
}
