package edu.harvard.med.countway.dl.rest;

import java.sql.SQLException;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

import org.apache.log4j.Logger;

import edu.harvard.med.countway.dl.dao.EcommonsUserDAO;
import edu.harvard.med.countway.dl.model.EcommonsUser;

// TODO: disabled until authenticated access is configured
//@Path("ecommons_user")
public class EcommonsUserResource
{
    private static final Logger log = Logger.getLogger(EcommonsUserResource.class);

    @Context
    UriInfo uriInfo;
    private final EcommonsUserDAO dao = new EcommonsUserDAO();
    
    // TODO: disabled until unsupported limit clause is fixed
    /*
    @GET
    @Produces({"application/xml", "text/plain"})
    public Response selectEcommonsUserList(
            @DefaultValue("0") @QueryParam("offset") final Integer offset,
            @QueryParam("ecid") final String ecid,
            @QueryParam("huid") final String huid,
            @DefaultValue("ecid") @QueryParam("sort") final SelectEcommonsUserListParams.Sort sort) throws SQLException
    {
        final SelectEcommonsUserListParams select = new SelectEcommonsUserListParams();
        select.setOffset(offset);
        select.setEcid(ecid);
        select.setHuid(huid);
        select.setSort(sort);
        final EcommonsUserList result = dao.selectEcommonsUserList(select);
        if (result == null)
        {
            return Utils.getNotFoundResponse("ecommons users not found");
        }
        return Response.ok(result).build();
    }
    */
    
    @GET
    @Path("{id}")
    @Produces({"application/xml", "text/plain"})
    public Response selectEcommonsUser(@PathParam("id") final String uid) throws SQLException
    {
        EcommonsUser ecuser = dao.selectEcommonsUserByUid(uid);
        if (ecuser == null)
        {
            ecuser = dao.selectEcommonsUserByEcid(uid);
        }
        if (ecuser == null)
        {
            ecuser = dao.selectEcommonsUserByHuid(uid);
        }
        if (ecuser == null)
        {
            return Utils.getNotFoundResponse("ecommons user "+uid+" not found");
        }
        return Response.ok(ecuser).build();
    }
    
    // TODO: add insert/update/delete methods
}
