package edu.harvard.med.countway.dl.rest;

import javax.naming.NamingException;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;

@Provider
public class NamingExceptionMapper implements ExceptionMapper<NamingException>
{
    private static final Logger log = Logger.getLogger(NamingExceptionMapper.class);

    public Response toResponse(NamingException e)
    {
        log.info(Utils.getStackTrace(e));
        return Utils.getServerErrorResponse(e);
    }
}
