package edu.harvard.med.countway.dl.rest;

import java.sql.SQLException;

import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

import org.apache.log4j.Logger;

import edu.harvard.med.countway.dl.dao.ResourceTypeDAO;
import edu.harvard.med.countway.dl.model.ResourceType;
import edu.harvard.med.countway.dl.model.ResourceTypeList;
import edu.harvard.med.countway.dl.model.SelectResourceTypeListParams;

@Path("resource_type")
public class ResourceTypeResource
{
    private static final Logger log = Logger.getLogger(ResourceTypeResource.class);

    @Context UriInfo uriInfo;
    private final ResourceTypeDAO dao = new ResourceTypeDAO();
    
    @GET
    @Produces({"application/xml", "text/plain"})
    public Response selectResourceTypeList(
            @DefaultValue("0") @QueryParam("offset") final Integer offset,
            @DefaultValue("name") @QueryParam("sort") final SelectResourceTypeListParams.Sort sort) throws SQLException
    {
        final SelectResourceTypeListParams select = new SelectResourceTypeListParams();
        select.setOffset(offset);
        select.setSort(sort);
        final ResourceTypeList result = dao.selectResourceTypeList(select);
        if (result == null)
        {
            return Utils.getNotFoundResponse("resource types not found");
        }
        return Response.ok(result).build();
    }

    @Path("{id}")
    @GET
    @Produces({"application/xml", "text/plain"})
    public Response selectResourceType(@PathParam("id") final Integer id) throws SQLException
    {
        final ResourceType resourceType = dao.selectResourceType(id);
        if (resourceType == null)
        {
            return Utils.getNotFoundResponse("resource type "+id+" not found");
        }
        return Response.ok(resourceType).build();
    }
}
