package edu.harvard.med.countway.dl.rest;

import java.io.IOException;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

import org.apache.log4j.Logger;

import edu.harvard.med.countway.tools.FileUtil;

@Path("schema.xsd")
public class SchemaResource
{
    private static final Logger log = Logger.getLogger(SchemaResource.class);

    @Context
    UriInfo uriInfo;
    
    @GET
    @Produces({"application/xml"})
    public Response getSchema() throws IOException
    {
        final String schema = FileUtil.getResourceString("schema.xsd");
        return Response.ok(schema).build();
    }
}
