package edu.harvard.med.countway.dl.rest;

import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.SolrServerException;

@Provider
public class SolrServerExceptionMapper implements ExceptionMapper<SolrServerException>
{
    private static final Logger log = Logger.getLogger(SolrServerExceptionMapper.class);

    public Response toResponse(SolrServerException e)
    {
        log.info(Utils.getStackTrace(e));
        return Utils.getServerErrorResponse(e);
    }
}
