package edu.harvard.med.countway.dl.rest;

import java.sql.SQLException;
import java.util.Date;

import javax.naming.NamingException;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

import org.apache.log4j.Logger;

import edu.harvard.med.countway.dl.dao.ClassDAO;
import edu.harvard.med.countway.dl.dao.HarvardLdapAttributeDAO;
import edu.harvard.med.countway.dl.dao.ResourceDAO;
import edu.harvard.med.countway.dl.dao.TocFeedDAO;
import edu.harvard.med.countway.dl.dao.UserDAO;
import edu.harvard.med.countway.dl.model.ClassList;
import edu.harvard.med.countway.dl.model.HarvardLdapAttribute;
import edu.harvard.med.countway.dl.model.HarvardLdapAttributeList;
import edu.harvard.med.countway.dl.model.ResourceList;
import edu.harvard.med.countway.dl.model.SelectClassListByUserIdParams;
import edu.harvard.med.countway.dl.model.SelectResourceListByUserIdParams;
import edu.harvard.med.countway.dl.model.SelectTocFeedListByUserIdParams;
import edu.harvard.med.countway.dl.model.SelectUserListParams;
import edu.harvard.med.countway.dl.model.TocFeedList;
import edu.harvard.med.countway.dl.model.User;
import edu.harvard.med.countway.dl.model.UserList;

//TODO: disabled until authenticated access is configured
//@Path("user")
public class UserResource
{
    private static final Logger log = Logger.getLogger(UserResource.class);

    @Context
    UriInfo uriInfo;
    private final UserDAO userDao = new UserDAO();
    private final ClassDAO classDao = new ClassDAO();
    private final ResourceDAO resourceDao = new ResourceDAO();
    private final TocFeedDAO tocFeedDao = new TocFeedDAO();
    private final HarvardLdapAttributeDAO harvardLdapAttributeDao;
    
    public UserResource() throws NamingException
    {
        harvardLdapAttributeDao = new HarvardLdapAttributeDAO();
    }
    
    @GET
    @Produces({"application/xml", "text/plain"})
    public Response selectUserList(
            @DefaultValue("0") @QueryParam("offset") final Integer offset,
            @QueryParam("ecid") final String ecid,
            @QueryParam("huid") final String huid,
            @DefaultValue("ecid") @QueryParam("sort") final SelectUserListParams.Sort sort) throws SQLException
    {
        final SelectUserListParams select = new SelectUserListParams();
        select.setOffset(offset);
        select.setEcid(ecid);
        select.setHuid(huid);
        select.setSort(sort);
        final UserList result = userDao.selectUserList(select);
        if (result == null)
        {
            return Utils.getNotFoundResponse("users not found");
        }
        return Response.ok(result).build();
    }
    
    @GET
    @Path("{id}")
    @Produces({"application/xml", "text/plain"})
    public Response selectUser(@PathParam("id") final Integer id) throws SQLException
    {
        final User user = userDao.selectUser(id);
        if (user == null)
        {
            return Utils.getNotFoundResponse("user "+id+" not found");
        }
        return Response.ok(user).build();
    }
    
    @GET
    @Path("{id}/class")
    @Produces({"application/xml", "text/plain"})
    public Response selectClassListByUserId(
            @DefaultValue("0") @QueryParam("offset") final Integer offset,
            @PathParam("id") final Integer userId,
            @QueryParam("active") final Boolean active,
            @QueryParam("future") final Boolean future,
            @DefaultValue("date") @QueryParam("sort") final SelectClassListByUserIdParams.Sort sort) throws SQLException
    {
        final SelectClassListByUserIdParams select = new SelectClassListByUserIdParams();
        select.setOffset(offset);
        select.setUserId(userId);
        select.setActive(active);
        select.setFuture(future);
        select.setNow(new Date());
        select.setSort(sort);
        final ClassList result = classDao.selectClassListByUserId(select);
        if (result == null)
        {
            return Utils.getNotFoundResponse("classes not found");
        }
        return Response.ok(result).build();
    }

    @GET
    @Path("{id}/resource")
    @Produces({"application/xml", "text/plain"})
    public Response selectResourceListByUserId(
            @DefaultValue("0") @QueryParam("offset") final Integer offset,
            @PathParam("id") final Integer userId,
            @DefaultValue("title") @QueryParam("sort") final SelectResourceListByUserIdParams.Sort sort) throws SQLException
    {
        final SelectResourceListByUserIdParams select = new SelectResourceListByUserIdParams();
        select.setOffset(offset);
        select.setUserId(userId);
        select.setSort(sort);
        final ResourceList result = resourceDao.selectResourceListByUserId(select);
        if (result == null)
        {
            return Utils.getNotFoundResponse("resources not found");
        }
        return Response.ok(result).build();
    }
    
    @GET
    @Path("{id}/toc_feed")
    @Produces({"application/xml", "text/plain"})
    public Response selectTocFeedListByUserId(
            @DefaultValue("0") @QueryParam("offset") final Integer offset,
            @PathParam("id") final Integer userId) throws SQLException
    {
        final SelectTocFeedListByUserIdParams select = new SelectTocFeedListByUserIdParams();
        select.setOffset(offset);
        select.setLimit(20);
        select.setUserId(userId);
        final TocFeedList result = tocFeedDao.selectTocFeedListByUserId(select);
        if (result == null)
        {
            return Utils.getNotFoundResponse("toc feeds not found");
        }
        return Response.ok(result).build();
    }
    
    @GET
    @Path("{id}/huldap")
    @Produces({"application/xml", "text/plain"})
    public Response selectHarvardLdapAttributeList(@PathParam("id") final Integer userId) throws SQLException, NamingException
    {
        final User user = userDao.selectUser(userId);
        
        if (user == null)
        {
            return Utils.getNotFoundResponse("user "+userId+" not found");
        }
        if (user.getHuid() == null)
        {
            return Utils.getNotFoundResponse("huid for user "+userId+" not found");
        }
        
        final HarvardLdapAttributeList result = harvardLdapAttributeDao.selectAttributeList(user.getHuid());
        
        if (result == null)
        {
            return Utils.getNotFoundResponse("harvard ldap attributes not found");
        }
        
        return Response.ok(result).build();
    }
    
    @GET
    @Path("{id}/huldap/{key}")
    @Produces({"application/xml", "text/plain"})
    public Response selectHarvardLdapAttribute(@PathParam("id") final Integer userId, @PathParam("key") final String key) throws SQLException, NamingException
    {
        final User user = userDao.selectUser(userId);
        
        if (user == null)
        {
            return Utils.getNotFoundResponse("user "+userId+" not found");
        }
        if (user.getHuid() == null)
        {
            return Utils.getNotFoundResponse("huid for user "+userId+" not found");
        }
        
        final HarvardLdapAttribute attr = harvardLdapAttributeDao.selectAttribute(user.getHuid(), key);
        
        if (attr == null)
        {
            return Utils.getNotFoundResponse("attribute not found");
        }
        
        return Response.ok(attr).build();
    }
    
    // TODO: add insert/update/delete methods
}
