/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.med.countway.dl.rest;

import edu.harvard.med.countway.dl.dao.ClassLocationDAO;
import edu.harvard.med.countway.dl.model.ClassLocation;
import edu.harvard.med.countway.dl.model.ClassLocationList;
import edu.harvard.med.countway.dl.model.SelectClassLocationListParams;
import edu.harvard.med.countway.dl.rest.Utils;
import java.sql.SQLException;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.log4j.Logger;

@Path(value="class_location")
public class ClassLocationResource {
    private static final Logger log = Logger.getLogger(ClassLocationResource.class);
    @Context
    UriInfo uriInfo;
    private final ClassLocationDAO dao = new ClassLocationDAO();

    @GET
    @Produces(value={"application/xml", "text/plain"})
    public Response selectClassLocationList(@DefaultValue(value="0") @QueryParam(value="offset") Integer offset, @DefaultValue(value="concat") @QueryParam(value="sort") SelectClassLocationListParams.Sort sort) throws SQLException {
        SelectClassLocationListParams select = new SelectClassLocationListParams();
        select.setOffset(offset);
        select.setSort(sort);
        ClassLocationList result = this.dao.selectClassLocationList(select);
        if (result == null) {
            return Utils.getNotFoundResponse("class locations not found");
        }
        return Response.ok((Object)result).build();
    }

    @GET
    @Path(value="{id}")
    @Produces(value={"application/xml", "text/plain"})
    public Response selectClassLocation(@PathParam(value="id") Integer id) throws SQLException {
        ClassLocation classLocation = this.dao.selectClassLocation(id);
        if (classLocation == null) {
            return Utils.getNotFoundResponse("class location " + id + " not found");
        }
        return Response.ok((Object)classLocation).build();
    }
}

