/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.med.countway.dl.rest;

import edu.harvard.med.countway.dl.dao.ClassDAO;
import edu.harvard.med.countway.dl.model.Class;
import edu.harvard.med.countway.dl.model.ClassList;
import edu.harvard.med.countway.dl.model.SelectClassListParams;
import edu.harvard.med.countway.dl.rest.Utils;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.log4j.Logger;

@Path(value="class")
public class ClassResource {
    private static final Logger log = Logger.getLogger(ClassResource.class);
    @Context
    UriInfo uriInfo;
    private final ClassDAO dao = new ClassDAO();

    @GET
    @Produces(value={"application/xml", "text/plain"})
    public Response selectClassList(@QueryParam(value="query") String query, @DefaultValue(value="0") @QueryParam(value="offset") Integer offset, @QueryParam(value="courseId") List<Integer> courseId, @QueryParam(value="institutionId") List<Integer> institutionId, @QueryParam(value="typeId") List<Integer> typeId, @QueryParam(value="buildingId") List<Integer> buildingId, @QueryParam(value="active") Boolean active, @QueryParam(value="future") Boolean future, @DefaultValue(value="title") @QueryParam(value="sort") SelectClassListParams.Sort sort) throws SQLException {
        SelectClassListParams select = new SelectClassListParams();
        select.setQuery(query);
        select.setOffset(offset);
        select.setCourseId(courseId);
        select.setInstitutionId(institutionId);
        select.setTypeId(typeId);
        select.setBuildingId(buildingId);
        select.setActive(active);
        select.setFuture(future);
        select.setNow(new Date());
        select.setSort(sort);
        ClassList result = this.dao.selectClassList(select);
        if (result == null) {
            return Utils.getNotFoundResponse("classes not found");
        }
        return Response.ok((Object)result).build();
    }

    @GET
    @Path(value="{id}")
    @Produces(value={"application/xml", "text/plain"})
    public Response selectClass(@PathParam(value="id") Integer id) throws SQLException {
        Class clazz = this.dao.selectClass(id);
        if (clazz == null) {
            return Utils.getNotFoundResponse("class " + id + " not found");
        }
        return Response.ok((Object)clazz).build();
    }
}

