/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.med.countway.dl.rest;

import edu.harvard.med.countway.dl.dao.CourseBuildingDAO;
import edu.harvard.med.countway.dl.model.CourseBuilding;
import edu.harvard.med.countway.dl.model.CourseBuildingList;
import edu.harvard.med.countway.dl.model.SelectCourseBuildingListParams;
import edu.harvard.med.countway.dl.rest.Utils;
import java.sql.SQLException;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.log4j.Logger;

@Path(value="course_building")
public class CourseBuildingResource {
    private static final Logger log = Logger.getLogger(CourseBuildingResource.class);
    @Context
    UriInfo uriInfo;
    private final CourseBuildingDAO dao = new CourseBuildingDAO();

    @GET
    @Produces(value={"application/xml", "text/plain"})
    public Response selectCourseBuildingList(@DefaultValue(value="0") @QueryParam(value="offset") Integer offset, @DefaultValue(value="concat") @QueryParam(value="sort") SelectCourseBuildingListParams.Sort sort) throws SQLException {
        SelectCourseBuildingListParams select = new SelectCourseBuildingListParams();
        select.setOffset(offset);
        select.setSort(sort);
        CourseBuildingList result = this.dao.selectCourseBuildingList(select);
        if (result == null) {
            return Utils.getNotFoundResponse("course buildings not found");
        }
        return Response.ok((Object)result).build();
    }

    @GET
    @Path(value="{id}")
    @Produces(value={"application/xml", "text/plain"})
    public Response selectCourseBuilding(@PathParam(value="id") Integer id) throws SQLException {
        CourseBuilding courseBuilding = this.dao.selectCourseBuilding(id);
        if (courseBuilding == null) {
            return Utils.getNotFoundResponse("course building " + id + " not found");
        }
        return Response.ok((Object)courseBuilding).build();
    }
}

