/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.med.countway.dl.rest;

import edu.harvard.med.countway.dl.dao.CourseInstitutionDAO;
import edu.harvard.med.countway.dl.model.CourseInstitution;
import edu.harvard.med.countway.dl.model.CourseInstitutionList;
import edu.harvard.med.countway.dl.model.SelectCourseInstitutionListParams;
import edu.harvard.med.countway.dl.rest.Utils;
import java.sql.SQLException;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.log4j.Logger;

@Path(value="course_institution")
public class CourseInstitutionResource {
    private static final Logger log = Logger.getLogger(CourseInstitutionResource.class);
    @Context
    UriInfo uriInfo;
    private final CourseInstitutionDAO dao = new CourseInstitutionDAO();

    @GET
    @Produces(value={"application/xml", "text/plain"})
    public Response selectCourseInstitutionList(@DefaultValue(value="0") @QueryParam(value="offset") Integer offset, @DefaultValue(value="name") @QueryParam(value="sort") SelectCourseInstitutionListParams.Sort sort) throws SQLException {
        SelectCourseInstitutionListParams select = new SelectCourseInstitutionListParams();
        select.setOffset(offset);
        select.setSort(sort);
        CourseInstitutionList result = this.dao.selectCourseInstitutionList(select);
        if (result == null) {
            return Utils.getNotFoundResponse("course institutions not found");
        }
        return Response.ok((Object)result).build();
    }

    @GET
    @Path(value="{id}")
    @Produces(value={"application/xml", "text/plain"})
    public Response selectCourseInstitution(@PathParam(value="id") Integer id) throws SQLException {
        CourseInstitution courseInstitution = this.dao.selectCourseInstitution(id);
        if (courseInstitution == null) {
            return Utils.getNotFoundResponse("course institution " + id + " not found");
        }
        return Response.ok((Object)courseInstitution).build();
    }
}

