/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.med.countway.dl.rest;

import edu.harvard.med.countway.dl.dao.EcommonsUserDAO;
import edu.harvard.med.countway.dl.model.EcommonsUser;
import edu.harvard.med.countway.dl.rest.Utils;
import java.sql.SQLException;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.log4j.Logger;

public class EcommonsUserResource {
    private static final Logger log = Logger.getLogger(EcommonsUserResource.class);
    @Context
    UriInfo uriInfo;
    private final EcommonsUserDAO dao = new EcommonsUserDAO();

    @GET
    @Path(value="{id}")
    @Produces(value={"application/xml", "text/plain"})
    public Response selectEcommonsUser(@PathParam(value="id") String uid) throws SQLException {
        EcommonsUser ecuser = this.dao.selectEcommonsUserByUid(uid);
        if (ecuser == null) {
            ecuser = this.dao.selectEcommonsUserByEcid(uid);
        }
        if (ecuser == null) {
            ecuser = this.dao.selectEcommonsUserByHuid(uid);
        }
        if (ecuser == null) {
            return Utils.getNotFoundResponse("ecommons user " + uid + " not found");
        }
        return Response.ok((Object)ecuser).build();
    }
}

