/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.med.countway.dl.rest;

import edu.harvard.med.countway.dl.dao.ResourceDAO;
import edu.harvard.med.countway.dl.dao.ResourceTypeDAO;
import edu.harvard.med.countway.dl.dao.TocFeedDAO;
import edu.harvard.med.countway.dl.model.Resource;
import edu.harvard.med.countway.dl.model.ResourceList;
import edu.harvard.med.countway.dl.model.ResourceTypeList;
import edu.harvard.med.countway.dl.model.SelectResourceListParams;
import edu.harvard.med.countway.dl.model.TocFeed;
import edu.harvard.med.countway.dl.rest.Utils;
import java.sql.SQLException;
import java.util.List;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.SolrServerException;

@Path(value="resource")
public class ResourceResource {
    private static final Logger log = Logger.getLogger(ResourceResource.class);
    @Context
    UriInfo uriInfo;
    private final ResourceDAO resourceDao = new ResourceDAO();
    private final ResourceTypeDAO resourceTypeDao = new ResourceTypeDAO();
    private final TocFeedDAO tocFeedDao = new TocFeedDAO();

    @GET
    @Produces(value={"application/xml", "text/plain"})
    public Response selectResourceList(@QueryParam(value="query") String query, @QueryParam(value="field") SelectResourceListParams.Field field, @DefaultValue(value="0") @QueryParam(value="offset") Integer offset, @QueryParam(value="typeId") List<Integer> typeId, @QueryParam(value="historical") Boolean historical, @DefaultValue(value="title") @QueryParam(value="sort") SelectResourceListParams.Sort sort) throws SolrServerException, SQLException {
        SelectResourceListParams select = new SelectResourceListParams();
        select.setQuery(query);
        select.setField(field);
        select.setOffset(offset);
        select.setTypeId(typeId);
        select.setHistorical(historical);
        select.setSort(sort);
        ResourceList result = this.resourceDao.selectResourceList(select);
        if (result == null) {
            return Utils.getNotFoundResponse("resources not found");
        }
        return Response.ok((Object)result).build();
    }

    @GET
    @Path(value="{id}")
    @Produces(value={"application/xml", "text/plain"})
    public Response selectResource(@PathParam(value="id") Integer id) throws SQLException {
        Resource resource = this.resourceDao.selectResource(id);
        if (resource == null) {
            return Utils.getNotFoundResponse("resource " + id + " not found");
        }
        return Response.ok((Object)resource).build();
    }

    @GET
    @Path(value="{id}/type")
    @Produces(value={"application/xml", "text/plain"})
    public Response selectResourceTypeListByResourceId(@PathParam(value="id") Integer resourceId) throws SQLException, SolrServerException {
        ResourceTypeList result = this.resourceTypeDao.selectResourceTypeListByResourceId(resourceId);
        if (result == null) {
            return Utils.getNotFoundResponse("resource types not found");
        }
        return Response.ok((Object)result).build();
    }

    @GET
    @Path(value="{id}/toc_feed")
    @Produces(value={"application/xml", "text/plain"})
    public Response selectTocFeedByResourceId(@PathParam(value="id") Integer resourceId) throws SQLException, SolrServerException {
        TocFeed tocFeed = this.tocFeedDao.selectTocFeedByResourceId(resourceId);
        if (tocFeed == null) {
            return Utils.getNotFoundResponse("toc feed not found");
        }
        return Response.ok((Object)tocFeed).build();
    }
}

