/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.med.countway.dl.rest;

import edu.harvard.med.countway.dl.dao.ResourceTypeDAO;
import edu.harvard.med.countway.dl.model.ResourceType;
import edu.harvard.med.countway.dl.model.ResourceTypeList;
import edu.harvard.med.countway.dl.model.SelectResourceTypeListParams;
import edu.harvard.med.countway.dl.rest.Utils;
import java.sql.SQLException;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.log4j.Logger;

@Path(value="resource_type")
public class ResourceTypeResource {
    private static final Logger log = Logger.getLogger(ResourceTypeResource.class);
    @Context
    UriInfo uriInfo;
    private final ResourceTypeDAO dao = new ResourceTypeDAO();

    @GET
    @Produces(value={"application/xml", "text/plain"})
    public Response selectResourceTypeList(@DefaultValue(value="0") @QueryParam(value="offset") Integer offset, @DefaultValue(value="name") @QueryParam(value="sort") SelectResourceTypeListParams.Sort sort) throws SQLException {
        SelectResourceTypeListParams select = new SelectResourceTypeListParams();
        select.setOffset(offset);
        select.setSort(sort);
        ResourceTypeList result = this.dao.selectResourceTypeList(select);
        if (result == null) {
            return Utils.getNotFoundResponse("resource types not found");
        }
        return Response.ok((Object)result).build();
    }

    @Path(value="{id}")
    @GET
    @Produces(value={"application/xml", "text/plain"})
    public Response selectResourceType(@PathParam(value="id") Integer id) throws SQLException {
        ResourceType resourceType = this.dao.selectResourceType(id);
        if (resourceType == null) {
            return Utils.getNotFoundResponse("resource type " + id + " not found");
        }
        return Response.ok((Object)resourceType).build();
    }
}

