package edu.harvard.med.countway.config;

import java.io.IOException;
import java.util.EnumSet;
import java.util.Properties;

import org.apache.log4j.Logger;

import edu.harvard.med.countway.tools.FileUtil;

public class CountwayConfig
{    
    private static final Logger log = Logger.getLogger(CountwayConfig.class);
    private static final String propsFileName = "countway.properties";
    private static long propsFileLastModified = 0;
    private static Properties props;
    
    static
    {
        try
        {
            props = FileUtil.getProperties(propsFileName);
            propsFileLastModified = FileUtil.getResourceLastModified(propsFileName);
        }
        catch (IOException e)
        {
            throw new ExceptionInInitializerError(e);
        }
    }

    public static String getProperty(final String key)
    {
        //refreshProperties();
        return props.getProperty(key);
    }
    
    public static String getProperty(final PropertyKey prop)
    {
        return getProperty(prop.getKey());
    }
    
    public static Properties getProperties()
    {
        return props;
    }
    
    private static void refreshProperties()
    {
        try
        {
            final long newPropsFileLastModified = FileUtil.getResourceLastModified(propsFileName);
            if (newPropsFileLastModified > propsFileLastModified)
            {
                props = FileUtil.getProperties(propsFileName);
                propsFileLastModified = newPropsFileLastModified;
            }
        }
        catch (IOException e)
        {
            log.warn("unable to reload config properties in file "+propsFileName+", keeping existing properties", e);
        }
    }
    
    // TODO: rename to actual key names?
    public static enum PropertyKey
    {
        // these should match key names in properties file
        DEPLOY_TIER("deploy_tier"),
        COUNTWAY_HEADER_FOOTER("countway_header_footer"),
        DUMMY_SESSION("dummy_session"),
        PIN_APP_NAME("pin_app_name"),
        PIN_PUB_KEY_FILE_NAME("pin_pubkey_file"),
        DL_TOC_FEEDS_PATH("dlfeeds_path"),
        DL_DB_HOST("dldb_host"),
        DL_DB_NAME("dldb_name"),
        DL_DB_USERNAME("dldb_user"),
        DL_DB_PASSWORD("dldb_pass"),
        DL_DB_DRIVER("dldb_driver"),
        DL_DB_URL("dldb_url"),
        SOLR_URL("solr_url"),
        CLASS_NOTIFICATION_FROM_EMAIL("class_notification_from_email"),
        GENERAL_NOTIFICATION_TO_EMAIL("general_notification_to_email"),
        COUNTWAY_INSTITUTION_ID("countway_institution_id"),
        JOURNAL_RESOURCE_TYPE_ID("journal_resource_type_id"),
        ECOMMONS_DB_HOST("ecdb_host"),
        ECOMMONS_DB_NAME("ecdb_name"),
        ECOMMONS_DB_USERNAME("ecdb_user"),
        ECOMMONS_DB_PASSWORD("ecdb_pass"),
        ECOMMONS_DB_DRIVER("ecdb_driver"),
        ECOMMONS_DB_URL("ecdb_url"),
        HMS_RT_HOST("rt_email_host"),
        HMS_SMTP_HOST("hms_smtp_host"),
        HMSACCESS_HMAC_PASSWD("hmsaccess_hmac_passwd"),
        HULDAP_UID("huldap_uid"),
        HULDAP_PASSWD("huldap_passwd"),
        HULDAP_URL("huldap_url"),
        HUID_AUTHZ_REQUEST_EMAIL("huid_authz_request_email"),
        // comma-separated list of ecid's who can register
        // for a class more than once on the behalf of other users
        // TODO: remove this
        CLASS_REG_PROXY("class_reg_proxy"),
        NCBI_EUTILS_BASE_URL("eutil_base_url"),
        NCBI_EUTILS_ESEARCH_URL("esearch_url"),
        NCBI_EUTILS_EFETCH_URL("efetch_url");
        
        private final String key;
        
        private PropertyKey(final String key)
        {
            this.key = key;
        }
        
        public String getKey()
        {
            return key;
        }
        
        public String toString()
        {
            return key;
        }
        
        public static PropertyKey fromString(final String key)
        {
            return getByKey(key);
        }
        
        public static PropertyKey getByKey(final String key)
        {
            PropertyKey rv = null;
            for (final PropertyKey prop: EnumSet.allOf(PropertyKey.class))
            {
                if (prop.getKey().equals(key))
                {
                    rv = prop;
                }
            }
            return rv;
        }
    }
}
