package edu.harvard.med.countway.config;

import java.util.EnumSet;

public enum DeployTier
{
    local,
    ddh4,
    dev,
    stage,
    prod;
    
    public static DeployTier fromString(final String value)
    {
        return getByValue(value);
    }
    
    public static DeployTier getByValue(final String value)
    {
        DeployTier rv = null;
        for (final DeployTier code: EnumSet.allOf(DeployTier.class))
        {
            if (code.toString().equals(value))
            {
                rv = code;
            }
        }
        return rv;
    }
}