package edu.harvard.med.countway.config;

import java.util.EnumSet;

public enum LoginType
{
    ecid,
    huid;
    
    public static LoginType fromString(final String value)
    {
        return getByValue(value);
    }
    
    public static LoginType getByValue(final String value)
    {
        LoginType rv = null;
        for (final LoginType code: EnumSet.allOf(LoginType.class))
        {
            if (code.toString().equals(value))
            {
                rv = code;
            }
        }
        return rv;
    }
}