package edu.harvard.med.countway.tools;

import org.apache.log4j.Logger;

import edu.harvard.med.countway.config.CountwayConfig;
import edu.harvard.med.countway.config.DeployTier;
import edu.harvard.med.countway.config.CountwayConfig.PropertyKey;

public abstract class AbstractTest
{
    protected static final Logger log = Logger.getLogger(AbstractTest.class);
    protected static final boolean DEBUG = log.isDebugEnabled();
    protected static final DeployTier tier = DeployTier.fromString(CountwayConfig.getProperty(PropertyKey.DEPLOY_TIER));
    
    protected boolean isNotLocalTier()
    {
        return !tier.equals(DeployTier.local);
    }
}
