package edu.harvard.med.countway.tools;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;

import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

import org.apache.commons.codec.binary.Hex;
import org.apache.log4j.Logger;

public class HmacUtil
{
    private static final Logger log = Logger.getLogger(HmacUtil.class);
    
    public static String getHmacMd5Hex(final String key, final String data)
    {
        final String result;
        try
        {
            // get an hmac_md5 key from the raw key bytes
            final SecretKeySpec signingKey = new SecretKeySpec(key.getBytes(), "HmacMD5");
            // get an hmac_md5 Mac instance and initialize with the signing key
            final Mac mac = Mac.getInstance("HmacMD5");
            mac.init(signingKey);
            // compute the hmac on input data bytes
            final byte[] rawHmac = mac.doFinal(data.getBytes());
            // hex-encode the hmac
            result = new String(Hex.encodeHex(rawHmac));
        }
        catch (NoSuchAlgorithmException e)
        {
            throw new HmacException(e);
        }
        catch (InvalidKeyException e)
        {
            throw new HmacException(e);
        }
        return result.toLowerCase();
    }
    
    @SuppressWarnings("serial")
    public static class HmacException extends RuntimeException
    {
        public HmacException(Throwable thr)
        {
            super("problem calculating hmac", thr);
        }
    }
}
