package edu.harvard.med.countway.tools;

import java.io.IOException;
import java.io.PrintStream;

import org.apache.log4j.Logger;
import org.apache.tools.mail.MailMessage;

import edu.harvard.med.countway.config.CountwayConfig;
import edu.harvard.med.countway.config.CountwayConfig.PropertyKey;

public class MailUtil
{
    private static final Logger log = Logger.getLogger(MailUtil.class);

    public static void sendMail(final String from, final String to, final String subj, final String body, final String bcc) throws IOException
    {
        final String server = CountwayConfig.getProperty(PropertyKey.HMS_SMTP_HOST);
        final MailMessage msg = new MailMessage(server);
        msg.setPort(25);
        msg.from(from);
        msg.to(to);
        if (bcc != null)
        {
            msg.bcc(bcc);
        }
        msg.setSubject(subj);
        final PrintStream out = msg.getPrintStream();
        out.println(body);
        msg.sendAndClose();
    }
}
