package edu.harvard.med.countway.tools;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import org.apache.log4j.Logger;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;

public class TemplateUtil
{
    private static final Logger log = Logger.getLogger(TemplateUtil.class);
    
    private static final Configuration config;

    static
    {
        config = new Configuration();
        config.setClassForTemplateLoading(TemplateUtil.class, "/");
    }

    public static String getClassRegisterMsg(String action, String title, Date date, String location)
    {
        try
        {
            final Template tmpl = config.getTemplate("class_register_msg.tmpl");
            final Map<String,String> model = new HashMap<String,String>();
            model.put("action", action);
            model.put("title", title);
            model.put("date", date.toString());
            model.put("location", location);
            final Writer out = new StringWriter();
            tmpl.process(model, out);
            return out.toString();
        }
        catch (IOException e)
        {
            throw new RuntimeException(e);
        }
        catch (TemplateException e)
        {
            throw new RuntimeException(e);
        }
    }
    
    public static String getClassRegisterEmail(String action, String title, Date date, Integer duration, String location, String scheme, String host)
    {
        try
        {
            final Template tmpl = config.getTemplate("class_register_email.tmpl");
            final Map<String,String> model = new HashMap<String,String>();
            model.put("action", action);
            model.put("title", title);
            model.put("date", date.toString());
            model.put("duration", duration.toString());
            model.put("location", location);
            model.put("scheme", scheme);
            model.put("host", host);
            final Writer out = new StringWriter();
            tmpl.process(model, out);
            return out.toString();
        }
        catch (IOException e)
        {
            throw new RuntimeException(e);
        }
        catch (TemplateException e)
        {
            throw new RuntimeException(e);
        }
    }
    
    public static String getClassAlreadyRegisteredMsg(String title, Date date, String location)
    {
        try
        {
            final Template tmpl = config.getTemplate("class_already_registered_msg.tmpl");
            final Map<String,String> model = new HashMap<String,String>();
            model.put("title", title);
            model.put("date", date.toString());
            model.put("location", location);
            final Writer out = new StringWriter();
            tmpl.process(model, out);
            return out.toString();
        }
        catch (IOException e)
        {
            throw new RuntimeException(e);
        }
        catch (TemplateException e)
        {
            throw new RuntimeException(e);
        }
    }

    public static String getClassStatusChangeEmail(String title, Date date, Integer duration, String location, String scheme, String host)
    {
        try
        {
            final Template tmpl = config.getTemplate("class_status_change_email.tmpl");
            final Map<String,String> model = new HashMap<String,String>();
            model.put("title", title);
            model.put("date", date.toString());
            model.put("duration", duration.toString());
            model.put("location", location);
            model.put("scheme", scheme);
            model.put("host", host);
            final Writer out = new StringWriter();
            tmpl.process(model, out);
            return out.toString();
        }
        catch (IOException e)
        {
            throw new RuntimeException(e);
        }
        catch (TemplateException e)
        {
            throw new RuntimeException(e);
        }        
    }
    
    public static String get(String tmplfile, Map<String,String> model)
    {
        try
        {
            final Template tmpl = config.getTemplate(tmplfile);
            final Writer out = new StringWriter();
            tmpl.process(model, out);
            return out.toString();
        }
        catch (IOException e)
        {
            throw new RuntimeException(e);
        }
        catch (TemplateException e)
        {
            throw new RuntimeException(e);
        }        
    }
}
