/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.cs.bloat.editor;

import EDU.purdue.cs.bloat.editor.ClassEditor;
import EDU.purdue.cs.bloat.editor.CodeArray;
import EDU.purdue.cs.bloat.editor.ConstantPool;
import EDU.purdue.cs.bloat.editor.IncOperand;
import EDU.purdue.cs.bloat.editor.Instruction;
import EDU.purdue.cs.bloat.editor.Label;
import EDU.purdue.cs.bloat.editor.LocalVariable;
import EDU.purdue.cs.bloat.editor.MemberRef;
import EDU.purdue.cs.bloat.editor.NameAndType;
import EDU.purdue.cs.bloat.editor.Opcode;
import EDU.purdue.cs.bloat.editor.TryCatch;
import EDU.purdue.cs.bloat.editor.Type;
import EDU.purdue.cs.bloat.editor.UseMap;
import EDU.purdue.cs.bloat.reflect.Catch;
import EDU.purdue.cs.bloat.reflect.ClassInfo;
import EDU.purdue.cs.bloat.reflect.LineNumberDebugInfo;
import EDU.purdue.cs.bloat.reflect.LocalDebugInfo;
import EDU.purdue.cs.bloat.reflect.MethodInfo;
import EDU.purdue.cs.bloat.tree.LocalExpr;
import EDU.purdue.cs.bloat.util.Assert;
import java.io.PrintStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class MethodEditor
implements Opcode {
    public static boolean PRESERVE_DEBUG = true;
    public static boolean UNIQUE_HANDLERS = false;
    public static boolean OPT_STACK_2 = false;
    private ClassEditor editor;
    private MethodInfo methodInfo;
    private String name;
    private Type type;
    private LinkedList code;
    private LinkedList tryCatches;
    private LinkedList lineNumbers;
    private LocalVariable[] params;
    private int maxStack;
    private int maxLabel;
    private int maxLocals;
    private boolean isDirty;
    private Map locals;
    private Type[] paramTypes;
    public UseMap uMap;
    private boolean isDeleted = false;

    public MethodEditor(ClassEditor editor, int modifiers, Class returnType, String methodName, Class[] paramTypes, Class[] exceptionTypes) {
        this(editor, modifiers, returnType == null ? null : Type.getType(returnType), methodName, MethodEditor.convertTypes(paramTypes), MethodEditor.convertTypes(exceptionTypes));
    }

    private static Type[] convertTypes(Class[] classes) {
        if (classes == null) {
            return null;
        }
        Type[] types = new Type[classes.length];
        int i = 0;
        while (i < types.length) {
            types[i] = Type.getType(classes[i]);
            ++i;
        }
        return types;
    }

    public MethodEditor(ClassEditor editor, int modifiers, Type returnType, String methodName, Type[] paramTypes, Type[] exceptionTypes) {
        int q;
        this.editor = editor;
        this.name = methodName;
        if (returnType == null) {
            returnType = Type.VOID;
        }
        if (paramTypes == null) {
            paramTypes = new Type[]{};
        }
        if (exceptionTypes == null) {
            exceptionTypes = new Type[]{};
        }
        ConstantPool cp = editor.constants();
        int nameIndex = cp.getUTF8Index(methodName);
        this.type = Type.getType(paramTypes, returnType);
        Assert.isTrue(this.type.isMethod(), "Method type not method: " + this.type);
        int typeIndex = cp.getTypeIndex(this.type);
        int exceptionIndex = cp.getUTF8Index("Exceptions");
        int[] exceptionTypeIndices = new int[exceptionTypes.length];
        int i = 0;
        while (i < exceptionTypes.length) {
            Type eType = exceptionTypes[i];
            exceptionTypeIndices[i] = cp.getTypeIndex(eType);
            ++i;
        }
        int codeIndex = cp.getUTF8Index("Code");
        ClassInfo classInfo = editor.classInfo();
        this.methodInfo = classInfo.addNewMethod(modifiers, typeIndex, nameIndex, exceptionIndex, exceptionTypeIndices, codeIndex);
        this.code = new LinkedList();
        this.tryCatches = new LinkedList();
        this.lineNumbers = new LinkedList();
        this.locals = new HashMap();
        this.params = !this.isStatic() ? new LocalVariable[this.type.stackHeight() + 1] : new LocalVariable[this.type.stackHeight()];
        this.paramTypes = new Type[this.params.length];
        Type[] indexedParams = this.type().indexedParamTypes();
        if (!this.isStatic()) {
            this.paramTypes[0] = this.declaringClass().type();
            q = 1;
            while (q < this.paramTypes.length) {
                this.paramTypes[q] = indexedParams[q - 1];
                ++q;
            }
        } else {
            q = 0;
            while (q < this.paramTypes.length) {
                this.paramTypes[q] = indexedParams[q];
                ++q;
            }
        }
        q = 0;
        while (q < this.params.length) {
            this.params[q] = new LocalVariable(null, this.paramTypes[q], q);
            ++q;
        }
        this.maxLocals = this.paramTypes.length;
        this.isDirty = true;
    }

    public MethodEditor(ClassEditor editor, MethodInfo methodInfo) {
        int end;
        LocalVariable[][] localVars;
        int i;
        int q;
        ConstantPool cp = editor.constants();
        this.methodInfo = methodInfo;
        this.editor = editor;
        this.isDirty = false;
        this.maxLabel = 0;
        this.maxLocals = methodInfo.maxLocals();
        this.maxStack = methodInfo.maxStack();
        this.locals = new HashMap();
        int index = methodInfo.nameIndex();
        this.name = (String)cp.constantAt(index);
        index = methodInfo.typeIndex();
        String typeName = (String)cp.constantAt(index);
        this.type = Type.getType(typeName);
        this.code = new LinkedList();
        this.tryCatches = new LinkedList();
        this.lineNumbers = new LinkedList();
        this.params = !this.isStatic() ? new LocalVariable[this.type.stackHeight() + 1] : new LocalVariable[this.type.stackHeight()];
        this.paramTypes = new Type[this.params.length];
        Type[] indexedParams = this.type().indexedParamTypes();
        if (!this.isStatic()) {
            this.paramTypes[0] = this.declaringClass().type();
            q = 1;
            while (q < this.paramTypes.length) {
                this.paramTypes[q] = indexedParams[q - 1];
                ++q;
            }
        } else {
            q = 0;
            while (q < this.paramTypes.length) {
                this.paramTypes[q] = indexedParams[q];
                ++q;
            }
        }
        q = 0;
        while (q < this.params.length) {
            this.params[q] = new LocalVariable(null, this.paramTypes[q], q);
            ++q;
        }
        byte[] array = methodInfo.code();
        if (array == null || array.length == 0) {
            return;
        }
        int[] next = new int[array.length];
        int[][] targets = new int[array.length][];
        int[][] lookups = new int[array.length][];
        Label[] label = new Label[array.length + 1];
        if (PRESERVE_DEBUG && array.length < 65536) {
            LocalDebugInfo[] locals = methodInfo.locals();
            int max = 0;
            i = 0;
            while (i < locals.length) {
                if (max <= locals[i].index()) {
                    max = locals[i].index() + 1;
                }
                ++i;
            }
            localVars = new LocalVariable[array.length][max];
            i = 0;
            while (i < locals.length) {
                int start = locals[i].startPC();
                end = start + locals[i].length();
                String localName = (String)cp.constantAt(locals[i].nameIndex());
                String localType = (String)cp.constantAt(locals[i].typeIndex());
                LocalVariable var = new LocalVariable(localName, Type.getType(localType), locals[i].index());
                int pc = start;
                while (pc <= end) {
                    if (pc < localVars.length) {
                        localVars[pc][locals[i].index()] = var;
                    }
                    ++pc;
                }
                if (start == 0 && locals[i].index() < this.params.length) {
                    this.params[locals[i].index()] = var;
                }
                ++i;
            }
            LineNumberDebugInfo[] lineNumbers = methodInfo.lineNumbers();
            i = 0;
            while (i < lineNumbers.length) {
                int start = lineNumbers[i].startPC();
                if (label[start] == null) {
                    label[start] = new Label(start, false);
                }
                this.addLineNumberEntry(label[start], lineNumbers[i].lineNumber());
                ++i;
            }
        } else {
            localVars = new LocalVariable[array.length][0];
        }
        label[0] = new Label(0, true);
        int numInst = 0;
        i = 0;
        while (i < array.length) {
            next[i] = this.munchCode(array, i, targets, lookups);
            ++numInst;
            if (targets[i] != null) {
                int j = 0;
                while (j < targets[i].length) {
                    if (targets[i][j] < array.length) {
                        label[targets[i][j]] = new Label(targets[i][j], true);
                    }
                    ++j;
                }
            }
            i = next[i];
        }
        Catch[] exc = methodInfo.exceptionHandlers();
        i = 0;
        while (i < exc.length) {
            int start = exc[i].startPC();
            end = exc[i].endPC();
            int handler = exc[i].handlerPC();
            label[start] = new Label(start, true);
            label[end] = new Label(end, true);
            label[handler] = new Label(handler, true);
            Type catchType = (Type)cp.constantAt(exc[i].catchTypeIndex());
            this.addTryCatch(new TryCatch(label[start], label[end], label[handler], catchType));
            ++i;
        }
        i = 0;
        while (i < array.length) {
            Instruction inst = new Instruction(array, i, targets[i], lookups[i], localVars[i], cp);
            if (label[i] != null) {
                this.code.add(label[i]);
            }
            this.code.add(inst);
            if ((inst.isJump() || inst.isReturn() || inst.isJsr() || inst.isRet() || inst.isThrow() || inst.isSwitch()) && next[i] < array.length) {
                label[next[i]] = new Label(next[i], true);
            }
            i = next[i];
        }
        label[array.length] = new Label(array.length, true);
        this.code.add(label[array.length]);
        this.maxLabel = array.length + 1;
        if (ClassEditor.DEBUG) {
            System.out.println("Editing method " + this.name + " " + this.type);
        }
        if (OPT_STACK_2) {
            this.uMap = new UseMap();
        }
        this.setDirty(false);
    }

    public Type[] exceptions() {
        ConstantPool cp = this.editor.constants();
        int[] indices = this.methodInfo.exceptionTypes();
        Type[] types = new Type[indices.length];
        int i = 0;
        while (i < indices.length) {
            types[i] = (Type)cp.constantAt(indices[i]);
            ++i;
        }
        return types;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void setDirty(boolean dirty) {
        this.isDirty = dirty;
        if (this.isDirty) {
            this.editor.setDirty(true);
        }
    }

    public void delete() {
        this.setDirty(true);
        this.isDeleted = true;
    }

    public Type[] paramTypes() {
        return this.paramTypes;
    }

    public LocalVariable paramAt(int index) {
        if (index >= this.params.length || this.params[index] == null) {
            LocalVariable local = new LocalVariable(index);
            if (index < this.params.length) {
                this.params[index] = local;
            }
            return local;
        }
        return this.params[index];
    }

    public MethodInfo methodInfo() {
        return this.methodInfo;
    }

    public ClassEditor declaringClass() {
        return this.editor;
    }

    public int maxLocals() {
        return this.maxLocals;
    }

    public boolean isPublic() {
        return (this.methodInfo.modifiers() & 1) != 0;
    }

    public boolean isPrivate() {
        return (this.methodInfo.modifiers() & 2) != 0;
    }

    public boolean isProtected() {
        return (this.methodInfo.modifiers() & 4) != 0;
    }

    public boolean isPackage() {
        return !this.isPublic() && !this.isPrivate() && !this.isProtected();
    }

    public boolean isStatic() {
        return (this.methodInfo.modifiers() & 8) != 0;
    }

    public boolean isFinal() {
        return (this.methodInfo.modifiers() & 0x10) != 0;
    }

    public boolean isSynchronized() {
        return (this.methodInfo.modifiers() & 0x20) != 0;
    }

    public boolean isNative() {
        return (this.methodInfo.modifiers() & 0x100) != 0;
    }

    public boolean isAbstract() {
        return (this.methodInfo.modifiers() & 0x400) != 0;
    }

    public boolean isInterface() {
        return this.editor.isInterface();
    }

    public void setPublic(boolean flag) {
        if (this.isDeleted) {
            String s = "Cannot change a field once it has been marked for deletion";
            throw new IllegalStateException("Cannot change a field once it has been marked for deletion");
        }
        int mod = this.methodInfo.modifiers();
        mod = flag ? (mod |= 1) : (mod &= 0xFFFFFFFE);
        this.methodInfo.setModifiers(mod);
        this.setDirty(true);
    }

    public void setPrivate(boolean flag) {
        if (this.isDeleted) {
            String s = "Cannot change a field once it has been marked for deletion";
            throw new IllegalStateException("Cannot change a field once it has been marked for deletion");
        }
        int mod = this.methodInfo.modifiers();
        mod = flag ? (mod |= 2) : (mod &= 0xFFFFFFFD);
        this.methodInfo.setModifiers(mod);
        this.setDirty(true);
    }

    public void setProtected(boolean flag) {
        if (this.isDeleted) {
            String s = "Cannot change a field once it has been marked for deletion";
            throw new IllegalStateException("Cannot change a field once it has been marked for deletion");
        }
        int mod = this.methodInfo.modifiers();
        mod = flag ? (mod |= 4) : (mod &= 0xFFFFFFFB);
        this.methodInfo.setModifiers(mod);
        this.setDirty(true);
    }

    public void setStatic(boolean flag) {
        if (this.isDeleted) {
            String s = "Cannot change a field once it has been marked for deletion";
            throw new IllegalStateException("Cannot change a field once it has been marked for deletion");
        }
        int mod = this.methodInfo.modifiers();
        mod = flag ? (mod |= 8) : (mod &= 0xFFFFFFF7);
        this.methodInfo.setModifiers(mod);
        this.setDirty(true);
    }

    public void setFinal(boolean flag) {
        if (this.isDeleted) {
            String s = "Cannot change a field once it has been marked for deletion";
            throw new IllegalStateException("Cannot change a field once it has been marked for deletion");
        }
        int mod = this.methodInfo.modifiers();
        mod = flag ? (mod |= 0x10) : (mod &= 0xFFFFFFEF);
        this.methodInfo.setModifiers(mod);
        this.setDirty(true);
    }

    public void setSynchronized(boolean flag) {
        if (this.isDeleted) {
            String s = "Cannot change a field once it has been marked for deletion";
            throw new IllegalStateException("Cannot change a field once it has been marked for deletion");
        }
        int mod = this.methodInfo.modifiers();
        mod = flag ? (mod |= 0x20) : (mod &= 0xFFFFFFDF);
        this.methodInfo.setModifiers(mod);
        this.setDirty(true);
    }

    public void setNative(boolean flag) {
        if (this.isDeleted) {
            String s = "Cannot change a field once it has been marked for deletion";
            throw new IllegalStateException("Cannot change a field once it has been marked for deletion");
        }
        int mod = this.methodInfo.modifiers();
        mod = flag ? (mod |= 0x100) : (mod &= 0xFFFFFEFF);
        this.methodInfo.setModifiers(mod);
        this.setDirty(true);
    }

    public void setAbstract(boolean flag) {
        int mod = this.methodInfo.modifiers();
        mod = flag ? (mod |= 0x400) : (mod &= 0xFFFFFBFF);
        this.methodInfo.setModifiers(mod);
        this.setDirty(true);
    }

    private int munchCode(byte[] code, int index, int[][] targets, int[][] lookups) {
        int opcode = Instruction.toUByte(code[index]);
        int next = index + Opcode.opcSize[opcode];
        switch (opcode) {
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 198: 
            case 199: {
                short target = Instruction.toShort(code[index + 1], code[index + 2]);
                targets[index] = new int[1];
                targets[index][0] = index + target;
                break;
            }
            case 167: 
            case 168: {
                short target = Instruction.toShort(code[index + 1], code[index + 2]);
                targets[index] = new int[1];
                targets[index][0] = index + target;
                break;
            }
            case 200: 
            case 201: {
                int target = Instruction.toInt(code[index + 1], code[index + 2], code[index + 3], code[index + 4]);
                targets[index] = new int[1];
                targets[index][0] = index + target;
                break;
            }
            case 169: {
                break;
            }
            case 170: {
                int j = index + 1;
                while (j % 4 != 0) {
                    ++j;
                }
                int target = Instruction.toInt(code[j], code[j + 1], code[j + 2], code[j + 3]);
                int lo = Instruction.toInt(code[j += 4], code[j + 1], code[j + 2], code[j + 3]);
                int hi = Instruction.toInt(code[j += 4], code[j + 1], code[j + 2], code[j + 3]);
                j += 4;
                lookups[index] = new int[2];
                lookups[index][0] = lo;
                lookups[index][1] = hi;
                targets[index] = new int[hi - lo + 2];
                int k = 0;
                targets[index][k++] = index + target;
                next = j + (hi - lo + 1) * 4;
                while (j < next) {
                    target = Instruction.toInt(code[j], code[j + 1], code[j + 2], code[j + 3]);
                    j += 4;
                    targets[index][k++] = index + target;
                }
                break;
            }
            case 171: {
                int j = index + 1;
                while (j % 4 != 0) {
                    ++j;
                }
                int target = Instruction.toInt(code[j], code[j + 1], code[j + 2], code[j + 3]);
                int npairs = Instruction.toInt(code[j += 4], code[j + 1], code[j + 2], code[j + 3]);
                lookups[index] = new int[npairs];
                targets[index] = new int[npairs + 1];
                int k = 0;
                targets[index][k++] = index + target;
                next = (j += 4) + npairs * 8;
                while (j < next) {
                    int value = Instruction.toInt(code[j], code[j + 1], code[j + 2], code[j + 3]);
                    target = Instruction.toInt(code[j += 4], code[j + 1], code[j + 2], code[j + 3]);
                    j += 4;
                    lookups[index][k - 1] = value;
                    targets[index][k++] = index + target;
                }
                break;
            }
            case 196: {
                next = code[index + 1] == -124 ? index + 6 : index + 4;
            }
        }
        return next;
    }

    public void clearCode() {
        if (this.isDeleted) {
            String s = "Cannot change a field once it has been marked for deletion";
            throw new IllegalStateException("Cannot change a field once it has been marked for deletion");
        }
        if (ClassEditor.DEBUG) {
            System.out.println("Clearing code");
            Thread.dumpStack();
        }
        this.code.clear();
        this.tryCatches.clear();
        this.maxLocals = 0;
        this.maxStack = 0;
        this.setDirty(true);
    }

    public void clearCode2() {
        this.code.clear();
        this.tryCatches.clear();
        this.maxStack = 0;
        this.setDirty(true);
    }

    public String name() {
        return this.name;
    }

    public boolean isConstructor() {
        return this.name.equals("<init>");
    }

    public Type type() {
        return this.type;
    }

    public NameAndType nameAndType() {
        return new NameAndType(this.name(), this.type());
    }

    public MemberRef memberRef() {
        return new MemberRef(this.declaringClass().type(), this.nameAndType());
    }

    public int codeLength() {
        return this.code.size();
    }

    public void setCode(List v) {
        if (this.isDeleted) {
            String s = "Cannot change a field once it has been marked for deletion";
            throw new IllegalStateException("Cannot change a field once it has been marked for deletion");
        }
        if (ClassEditor.DEBUG) {
            System.out.println("Setting code to " + v.size() + " instructions");
            Thread.dumpStack();
        }
        this.code = new LinkedList(v);
        this.setDirty(true);
    }

    public List code() {
        return this.code;
    }

    public Label firstBlock() {
        Iterator iter = this.code.iterator();
        while (iter.hasNext()) {
            Label l;
            Object obj = iter.next();
            if (!(obj instanceof Label) || !(l = (Label)obj).startsBlock()) continue;
            return l;
        }
        return null;
    }

    public Label nextBlock(Label label) {
        boolean seen = false;
        Iterator iter = this.code.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!(obj instanceof Label)) continue;
            if (seen) {
                Label l = (Label)obj;
                if (!l.startsBlock()) continue;
                return l;
            }
            if (!label.equals(obj)) continue;
            seen = true;
        }
        return null;
    }

    public void removeCodeAt(int i) {
        if (this.isDeleted) {
            String s = "Cannot change a field once it has been marked for deletion";
            throw new IllegalStateException("Cannot change a field once it has been marked for deletion");
        }
        this.code.remove(i);
        this.setDirty(true);
    }

    public void insertCodeAt(Object obj, int i) {
        if (this.isDeleted) {
            String s = "Cannot change a field once it has been marked for deletion";
            throw new IllegalStateException("Cannot change a field once it has been marked for deletion");
        }
        this.code.add(i, obj);
        this.setDirty(true);
    }

    public void replaceCodeAt(Object obj, int i) {
        if (this.isDeleted) {
            String s = "Cannot change a field once it has been marked for deletion";
            throw new IllegalStateException("Cannot change a field once it has been marked for deletion");
        }
        this.code.set(i, obj);
        this.setDirty(true);
    }

    public Object codeElementAt(int i) {
        return this.code.get(i);
    }

    public void addLineNumberEntry(Label label, int lineNumber) {
        if (this.isDeleted) {
            String s = "Cannot change a field once it has been marked for deletion";
            throw new IllegalStateException("Cannot change a field once it has been marked for deletion");
        }
        this.lineNumbers.add(new LineNumberEntry(label, lineNumber));
        this.setDirty(true);
    }

    public int numTryCatches() {
        return this.tryCatches.size();
    }

    public Collection tryCatches() {
        return this.tryCatches;
    }

    public void addTryCatch(TryCatch tryCatch) {
        if (this.isDeleted) {
            String s = "Cannot change a field once it has been marked for deletion";
            throw new IllegalStateException("Cannot change a field once it has been marked for deletion");
        }
        if (ClassEditor.DEBUG) {
            System.out.println("add " + tryCatch);
        }
        this.tryCatches.add(tryCatch);
        this.setDirty(true);
    }

    public LocalVariable newLocal(Type type) {
        int index = this.maxLocals;
        this.maxLocals += type.stackHeight();
        this.setDirty(true);
        LocalVariable local = new LocalVariable(index);
        this.locals.put(new Integer(index), local);
        return local;
    }

    public LocalVariable newLocal(boolean isWide) {
        if (this.isDeleted) {
            String s = "Cannot change a field once it has been marked for deletion";
            throw new IllegalStateException("Cannot change a field once it has been marked for deletion");
        }
        int index = this.maxLocals;
        this.maxLocals += isWide ? 2 : 1;
        this.setDirty(true);
        LocalVariable local = new LocalVariable(index);
        this.locals.put(new Integer(index), local);
        return local;
    }

    public LocalVariable localAt(int index) {
        LocalVariable local = (LocalVariable)this.locals.get(new Integer(index));
        if (local == null) {
            local = new LocalVariable(index);
            this.locals.put(new Integer(index), local);
            if (index >= this.maxLocals) {
                this.maxLocals = index++;
            }
        }
        return local;
    }

    public void addInstruction(int opcodeClass) {
        this.addInstruction(new Instruction(opcodeClass));
    }

    public void addInstruction(int opcodeClass, Object operand) {
        this.addInstruction(new Instruction(opcodeClass, operand));
    }

    public void addInstruction(Instruction inst) {
        if (this.isDeleted) {
            String s = "Cannot change a field once it has been marked for deletion";
            throw new IllegalStateException("Cannot change a field once it has been marked for deletion");
        }
        if (ClassEditor.DEBUG) {
            System.out.println("    " + inst + " to " + System.identityHashCode(this) + ":" + System.identityHashCode(this.code));
        }
        this.code.add(inst);
        this.setDirty(true);
    }

    public Label newLabel() {
        if (this.isDeleted) {
            String s = "Cannot change a field once it has been marked for deletion";
            throw new IllegalStateException("Cannot change a field once it has been marked for deletion");
        }
        this.setDirty(true);
        return new Label(this.maxLabel++);
    }

    public Label newLabelTrue() {
        return new Label(this.maxLabel++, true);
    }

    public void addLabel(Label label) {
        if (this.isDeleted) {
            String s = "Cannot change a field once it has been marked for deletion";
            throw new IllegalStateException("Cannot change a field once it has been marked for deletion");
        }
        if (ClassEditor.DEBUG) {
            System.out.println("    " + label + " to " + System.identityHashCode(this) + ":" + System.identityHashCode(this.code));
        }
        if (label.index() >= this.maxLabel) {
            this.maxLabel = label.index() + 1;
        }
        this.code.add(label);
        this.setDirty(true);
    }

    public void commit() {
        if (ClassEditor.DEBUG) {
            System.out.println("Committing method " + this.name + " " + this.type + ": " + this.code.size() + " insts " + System.identityHashCode(this) + ":" + System.identityHashCode(this.code));
        }
        ConstantPool cp = this.editor.constants();
        if (this.isDeleted) {
            int nameIndex = cp.getUTF8Index(this.name);
            int typeIndex = cp.getTypeIndex(this.type);
            this.editor.classInfo().deleteMethod(nameIndex, typeIndex);
        } else {
            TryCatch tc;
            this.methodInfo.setNameIndex(cp.addConstant(1, this.name));
            this.methodInfo.setTypeIndex(cp.addConstant(1, this.type.descriptor()));
            if (this.isNative() || this.isAbstract()) {
                return;
            }
            ArrayList<LocalVarEntry> vars = new ArrayList<LocalVarEntry>();
            LinkedList copy = new LinkedList();
            Iterator iter = this.code.iterator();
            block0: while (iter.hasNext()) {
                Object ce = iter.next();
                if (ce instanceof Label) {
                    copy.add(ce);
                    continue;
                }
                Instruction inst = (Instruction)ce;
                LocalVariable var = null;
                if (inst.operand() instanceof LocalVariable) {
                    var = (LocalVariable)inst.operand();
                } else if (inst.operand() instanceof IncOperand) {
                    var = ((IncOperand)inst.operand()).var();
                }
                if (var == null || var.name() == null || var.type() == null) {
                    copy.add(ce);
                    continue;
                }
                int j = vars.size() - 1;
                while (j >= 0) {
                    LocalVarEntry v = (LocalVarEntry)vars.get(j);
                    if (v.var.equals(var)) {
                        v.end = this.newLabel();
                        copy.add(ce);
                        copy.add(v.end);
                        continue block0;
                    }
                    if (v.var.index() == var.index()) break;
                    --j;
                }
                Label start = this.newLabel();
                Label end = this.newLabel();
                vars.add(new LocalVarEntry(var, start, end));
                copy.add(start);
                copy.add(ce);
                copy.add(end);
            }
            HashSet<Label> seen = new HashSet<Label>();
            ArrayList<TryCatch> dup = new ArrayList<TryCatch>();
            iter = this.tryCatches.iterator();
            while (iter.hasNext()) {
                TryCatch tc2 = (TryCatch)iter.next();
                if (!seen.contains(tc2.handler())) {
                    if (ClassEditor.DEBUG) {
                        System.out.println("See " + tc2.handler());
                    }
                    seen.add(tc2.handler());
                    continue;
                }
                if (ClassEditor.DEBUG) {
                    System.out.println("See " + tc2.handler() + " again");
                }
                dup.add(tc2);
            }
            if (dup.size() != 0) {
                ListIterator<Object> liter = copy.listIterator();
                while (liter.hasNext()) {
                    Object ce = liter.next();
                    if (!(ce instanceof Label)) continue;
                    Iterator d = ((AbstractList)dup).iterator();
                    while (d.hasNext()) {
                        tc = (TryCatch)d.next();
                        if (!tc.handler().equals(ce)) continue;
                        Label handler2 = this.newLabel();
                        Label code = this.newLabel();
                        Instruction nop = new Instruction(0);
                        liter.add(nop);
                        Instruction jump = new Instruction(167, code);
                        liter.add(jump);
                        liter.add(handler2);
                        nop = new Instruction(0);
                        liter.add(nop);
                        jump = new Instruction(167, code);
                        liter.add(jump);
                        liter.add(code);
                        if (ClassEditor.DEBUG) {
                            System.out.println("Insert " + jump);
                            System.out.println("Insert " + handler2);
                            System.out.println("Insert " + jump);
                            System.out.println("Insert " + code);
                        }
                        tc.setHandler(handler2);
                        d.remove();
                    }
                }
            }
            CodeArray array = new CodeArray(this, cp, copy);
            byte[] arr = array.array();
            this.methodInfo.setCode(arr);
            this.methodInfo.setMaxLocals(array.maxLocals());
            this.methodInfo.setMaxStack(array.maxStack());
            if (PRESERVE_DEBUG && arr.length < 65536) {
                LocalDebugInfo[] locals = new LocalDebugInfo[vars.size()];
                int i = 0;
                while (i < vars.size()) {
                    int end;
                    LocalVarEntry entry = (LocalVarEntry)vars.get(i);
                    int start = array.labelIndex(entry.start);
                    if (start < (end = array.labelIndex(entry.end))) {
                        locals[i] = new LocalDebugInfo(start, end - start, cp.addConstant(1, entry.var.name()), cp.addConstant(1, entry.var.type().descriptor()), entry.var.index());
                    }
                    ++i;
                }
                this.methodInfo.setLocals(locals);
                LineNumberDebugInfo[] lines = new LineNumberDebugInfo[this.lineNumbers.size()];
                int i2 = 0;
                iter = this.lineNumbers.iterator();
                while (iter.hasNext()) {
                    LineNumberEntry line = (LineNumberEntry)iter.next();
                    lines[i2++] = new LineNumberDebugInfo(array.labelIndex(line.label), line.lineNumber);
                }
                this.methodInfo.setLineNumbers(lines);
            } else {
                this.methodInfo.setLineNumbers(null);
                this.methodInfo.setLocals(null);
            }
            LinkedList<Catch> c = new LinkedList<Catch>();
            iter = this.tryCatches.iterator();
            while (iter.hasNext()) {
                int end;
                tc = (TryCatch)iter.next();
                int start = array.labelIndex(tc.start());
                if (start >= (end = array.labelIndex(tc.end()))) continue;
                c.add(new Catch(start, end, array.labelIndex(tc.handler()), cp.addConstant(7, tc.type())));
            }
            Object[] a = c.toArray();
            Catch[] catches = new Catch[a.length];
            System.arraycopy(a, 0, catches, 0, a.length);
            this.methodInfo.setExceptionHandlers(catches);
        }
        if (ClassEditor.DEBUG) {
            System.out.println("MethodInfo after commit: " + this.methodInfo);
        }
        this.isDirty = false;
    }

    public void print(PrintStream out) {
        out.println(String.valueOf(this.name) + "." + this.type + (this.isDirty ? " (dirty) " : "") + ":");
        Iterator iter = this.code.iterator();
        while (iter.hasNext()) {
            out.println("    " + iter.next());
        }
        iter = this.tryCatches.iterator();
        while (iter.hasNext()) {
            out.println("    " + iter.next());
        }
    }

    public boolean equals(Object o) {
        if (o instanceof MethodEditor) {
            MethodEditor other = (MethodEditor)o;
            if (!other.declaringClass().equals(this.declaringClass())) {
                return false;
            }
            if (!other.name().equals(this.name())) {
                return false;
            }
            return other.type().equals(this.type());
        }
        return false;
    }

    public int hashCode() {
        return this.declaringClass().hashCode() + this.name().hashCode() + this.type().hashCode();
    }

    public String toString() {
        return this.editor.type() + "." + this.name + this.type;
    }

    public UseMap uMap() {
        return this.uMap;
    }

    public void rememberDef(LocalExpr e) {
        if (OPT_STACK_2) {
            this.uMap.add(e, (Instruction)this.code.get(this.code.size() - 1));
        }
    }

    class LineNumberEntry {
        Label label;
        int lineNumber;

        public LineNumberEntry(Label label, int lineNumber) {
            this.label = label;
            this.lineNumber = lineNumber;
        }
    }

    class LocalInfo {
        LocalVariable var;
        Type type;

        public LocalInfo(LocalVariable var, Type type) {
            this.var = var;
            this.type = type;
        }

        public boolean equals(Object obj) {
            return obj != null && obj instanceof LocalInfo && ((LocalInfo)obj).var.equals(this.var) && ((LocalInfo)obj).type.equals(this.type);
        }

        public int hashCode() {
            return this.var.hashCode() ^ this.type.hashCode();
        }
    }

    class LocalVarEntry {
        LocalVariable var;
        Label start;
        Label end;

        public LocalVarEntry(LocalVariable var, Label start, Label end) {
            this.var = var;
            this.start = start;
            this.end = end;
        }
    }
}

