/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.cs.bloat.file;

import EDU.purdue.cs.bloat.file.Attribute;
import EDU.purdue.cs.bloat.file.ClassFileLoader;
import EDU.purdue.cs.bloat.file.Code;
import EDU.purdue.cs.bloat.file.Exceptions;
import EDU.purdue.cs.bloat.file.Field;
import EDU.purdue.cs.bloat.file.GenericAttribute;
import EDU.purdue.cs.bloat.file.Method;
import EDU.purdue.cs.bloat.reflect.ClassFormatException;
import EDU.purdue.cs.bloat.reflect.ClassInfo;
import EDU.purdue.cs.bloat.reflect.ClassInfoLoader;
import EDU.purdue.cs.bloat.reflect.Constant;
import EDU.purdue.cs.bloat.reflect.FieldInfo;
import EDU.purdue.cs.bloat.reflect.MethodInfo;
import EDU.purdue.cs.bloat.util.Assert;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class ClassFile
implements ClassInfo {
    private ClassInfoLoader loader;
    private List constants;
    private int modifiers;
    private int thisClass;
    private int superClass;
    private int[] interfaces;
    private Field[] fields;
    private Method[] methods;
    private Attribute[] attrs;
    private File file;
    private int major = 45;
    private int minor = 3;

    public ClassFile(File file, ClassInfoLoader loader, DataInputStream in) {
        this.loader = loader;
        this.file = file;
        try {
            if (ClassFileLoader.DEBUG) {
                System.out.println("ClassFile: Reading header");
            }
            this.readHeader(in);
            if (ClassFileLoader.DEBUG) {
                System.out.println("ClassFile: Reading constant pool");
            }
            this.readConstantPool(in);
            if (ClassFileLoader.DEBUG) {
                System.out.println("ClassFile: Reading access flags");
            }
            this.readAccessFlags(in);
            if (ClassFileLoader.DEBUG) {
                System.out.println("ClassFile: Reading class info");
            }
            this.readClassInfo(in);
            if (ClassFileLoader.DEBUG) {
                System.out.println("ClassFile: Reading fields");
            }
            this.readFields(in);
            if (ClassFileLoader.DEBUG) {
                System.out.println("ClassFile: Reading methods");
            }
            this.readMethods(in);
            if (ClassFileLoader.DEBUG) {
                System.out.println("ClassFile: Reading Attributes");
            }
            this.readAttributes(in);
            in.close();
        }
        catch (IOException e) {
            throw new ClassFormatException(String.valueOf(e.getMessage()) + " (in file " + file + ")");
        }
    }

    public ClassFile(int modifiers, int classIndex, int superClassIndex, int[] interfaceIndexes, List constants, ClassInfoLoader loader) {
        this.modifiers = modifiers;
        this.thisClass = classIndex;
        this.superClass = superClassIndex;
        this.interfaces = interfaceIndexes;
        this.constants = constants;
        this.loader = loader;
        this.fields = new Field[0];
        this.methods = new Method[0];
        this.attrs = new Attribute[0];
    }

    public ClassInfoLoader loader() {
        return this.loader;
    }

    public String name() {
        Integer nameIndex;
        Constant c = (Constant)this.constants.get(this.thisClass);
        Assert.isNotNull(c, "Null constant for class name");
        if (c.tag() == 7 && (nameIndex = (Integer)c.value()) != null && (c = (Constant)this.constants.get(nameIndex)).tag() == 1) {
            return (String)c.value();
        }
        throw new ClassFormatException("Couldn't find class name in file");
    }

    public void setClassIndex(int index) {
        this.thisClass = index;
    }

    public void setSuperclassIndex(int index) {
        this.superClass = index;
    }

    public void setInterfaceIndices(int[] indices) {
        this.interfaces = indices;
    }

    public int classIndex() {
        return this.thisClass;
    }

    public int superclassIndex() {
        return this.superClass;
    }

    public int[] interfaceIndices() {
        return this.interfaces;
    }

    public void setModifiers(int modifiers) {
        this.modifiers = modifiers;
    }

    public int modifiers() {
        return this.modifiers;
    }

    public FieldInfo[] fields() {
        return this.fields;
    }

    public MethodInfo[] methods() {
        return this.methods;
    }

    public void setMethods(MethodInfo[] methods) {
        this.methods = new Method[methods.length];
        int i = 0;
        while (i < methods.length) {
            this.methods[i] = (Method)methods[i];
            ++i;
        }
    }

    public Constant[] constants() {
        return this.constants.toArray(new Constant[0]);
    }

    public void setConstants(Constant[] constants) {
        this.constants = new ArrayList(constants.length);
        int i = 0;
        while (i < constants.length) {
            this.constants.add(i, constants[i]);
            ++i;
        }
    }

    public File file() {
        return this.file;
    }

    public File outputFile() {
        File outputDir = ((ClassFileLoader)this.loader).outputDir();
        String fileName = this.name().replace('/', File.separatorChar);
        return new File(outputDir, String.valueOf(fileName) + ".class");
    }

    public void commit() {
        try {
            this.commitTo(this.loader.outputStreamFor(this));
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    void commitTo(OutputStream outStream) {
        try {
            DataOutputStream out = new DataOutputStream(outStream);
            this.writeHeader(out);
            this.writeConstantPool(out);
            this.writeAccessFlags(out);
            this.writeClassInfo(out);
            this.writeFields(out, null);
            this.writeMethods(out, null);
            this.writeAttributes(out);
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public void commitOnly(Set methods, Set fields) {
        try {
            OutputStream outStream = this.loader.outputStreamFor(this);
            DataOutputStream out = new DataOutputStream(outStream);
            this.writeHeader(out);
            this.writeConstantPool(out);
            this.writeAccessFlags(out);
            this.writeClassInfo(out);
            this.writeFields(out, fields);
            this.writeMethods(out, methods);
            this.writeAttributes(out);
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private void writeHeader(DataOutputStream out) throws IOException {
        out.writeInt(-889275714);
        out.writeShort(this.major);
        out.writeShort(this.minor);
    }

    private void writeConstantPool(DataOutputStream out) throws IOException {
        out.writeShort(this.constants.size());
        int i = 1;
        while (i < this.constants.size()) {
            this.writeConstant(out, (Constant)this.constants.get(i));
            switch (((Constant)this.constants.get(i)).tag()) {
                case 5: 
                case 6: {
                    ++i;
                }
            }
            ++i;
        }
    }

    private Constant readConstant(DataInputStream in) throws IOException {
        Object value;
        int tag = in.readUnsignedByte();
        switch (tag) {
            case 7: 
            case 8: {
                value = new Integer(in.readUnsignedShort());
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                value = new int[]{in.readUnsignedShort(), in.readUnsignedShort()};
                break;
            }
            case 3: {
                value = new Integer(in.readInt());
                break;
            }
            case 4: {
                value = new Float(in.readFloat());
                break;
            }
            case 5: {
                value = new Long(in.readLong());
                break;
            }
            case 6: {
                value = new Double(in.readDouble());
                break;
            }
            case 1: {
                value = in.readUTF();
                break;
            }
            default: {
                throw new ClassFormatException(String.valueOf(this.file.getPath()) + ": Invalid constant tag: " + tag);
            }
        }
        return new Constant(tag, value);
    }

    private void writeConstant(DataOutputStream out, Constant constant) throws IOException {
        int tag = constant.tag();
        Object value = constant.value();
        out.writeByte(tag);
        switch (tag) {
            case 7: 
            case 8: {
                out.writeShort((Integer)value);
                break;
            }
            case 3: {
                out.writeInt((Integer)value);
                break;
            }
            case 4: {
                out.writeFloat(((Float)value).floatValue());
                break;
            }
            case 5: {
                out.writeLong((Long)value);
                break;
            }
            case 6: {
                out.writeDouble((Double)value);
                break;
            }
            case 1: {
                out.writeUTF((String)value);
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                out.writeShort(((int[])value)[0]);
                out.writeShort(((int[])value)[1]);
            }
        }
    }

    private void writeAccessFlags(DataOutputStream out) throws IOException {
        out.writeShort(this.modifiers);
    }

    private void writeClassInfo(DataOutputStream out) throws IOException {
        out.writeShort(this.thisClass);
        out.writeShort(this.superClass);
        out.writeShort(this.interfaces.length);
        int i = 0;
        while (i < this.interfaces.length) {
            out.writeShort(this.interfaces[i]);
            ++i;
        }
    }

    private void writeFields(DataOutputStream out, Set onlyFields) throws IOException {
        out.writeShort(this.fields.length);
        int i = 0;
        while (i < this.fields.length) {
            if (onlyFields == null || !onlyFields.contains(this.fields[i])) {
                this.fields[i].write(out);
            }
            ++i;
        }
    }

    private void writeMethods(DataOutputStream out, Set onlyMethods) throws IOException {
        if (onlyMethods != null) {
            out.writeShort(onlyMethods.size());
        } else {
            if (Method.DEBUG) {
                System.out.println("Writing " + this.methods.length + " methods");
            }
            out.writeShort(this.methods.length);
        }
        int i = 0;
        while (i < this.methods.length) {
            if (onlyMethods == null || !onlyMethods.contains(this.methods[i])) {
                this.methods[i].write(out);
            }
            ++i;
        }
    }

    private void writeAttributes(DataOutputStream out) throws IOException {
        out.writeShort(this.attrs.length);
        int i = 0;
        while (i < this.attrs.length) {
            out.writeShort(this.attrs[i].nameIndex());
            out.writeInt(this.attrs[i].length());
            this.attrs[i].writeData(out);
            ++i;
        }
    }

    private void readHeader(DataInputStream in) throws IOException {
        int magic = in.readInt();
        if (magic != -889275714) {
            throw new ClassFormatError("Bad magic number.");
        }
        this.major = in.readUnsignedShort();
        this.minor = in.readUnsignedShort();
    }

    private void readConstantPool(DataInputStream in) throws IOException {
        int count = in.readUnsignedShort();
        this.constants = new ArrayList(count);
        this.constants.add(0, null);
        int i = 1;
        while (i < count) {
            this.constants.add(i, this.readConstant(in));
            switch (((Constant)this.constants.get(i)).tag()) {
                case 5: 
                case 6: {
                    this.constants.add(++i, null);
                }
            }
            ++i;
        }
    }

    private void readAccessFlags(DataInputStream in) throws IOException {
        this.modifiers = in.readUnsignedShort();
    }

    private void readClassInfo(DataInputStream in) throws IOException {
        this.thisClass = in.readUnsignedShort();
        this.superClass = in.readUnsignedShort();
        int numInterfaces = in.readUnsignedShort();
        this.interfaces = new int[numInterfaces];
        int i = 0;
        while (i < numInterfaces) {
            this.interfaces[i] = in.readUnsignedShort();
            ++i;
        }
    }

    private void readFields(DataInputStream in) throws IOException {
        int numFields = in.readUnsignedShort();
        this.fields = new Field[numFields];
        int i = 0;
        while (i < numFields) {
            this.fields[i] = new Field(in, this);
            ++i;
        }
    }

    private void readMethods(DataInputStream in) throws IOException {
        int numMethods = in.readUnsignedShort();
        this.methods = new Method[numMethods];
        int i = 0;
        while (i < numMethods) {
            this.methods[i] = new Method(in, this);
            ++i;
        }
    }

    private void readAttributes(DataInputStream in) throws IOException {
        int numAttributes = in.readUnsignedShort();
        this.attrs = new Attribute[numAttributes];
        int i = 0;
        while (i < numAttributes) {
            int nameIndex = in.readUnsignedShort();
            int length = in.readInt();
            this.attrs[i] = new GenericAttribute(in, nameIndex, length);
            ++i;
        }
    }

    public FieldInfo addNewField(int modifiers, int typeIndex, int nameIndex) {
        Field field = new Field(this, modifiers, typeIndex, nameIndex);
        Field[] fields = new Field[this.fields.length + 1];
        int i = 0;
        while (i < this.fields.length) {
            fields[i] = this.fields[i];
            ++i;
        }
        fields[this.fields.length] = field;
        this.fields = fields;
        return field;
    }

    public FieldInfo addNewField(int modifiers, int typeIndex, int nameIndex, int cvNameIndex, int constantValueIndex) {
        Field field = new Field(this, modifiers, typeIndex, nameIndex, cvNameIndex, constantValueIndex);
        Field[] fields = new Field[this.fields.length + 1];
        int i = 0;
        while (i < this.fields.length) {
            fields[i] = this.fields[i];
            ++i;
        }
        fields[this.fields.length] = field;
        this.fields = fields;
        return field;
    }

    public void deleteField(int nameIndex) {
        ArrayList<Field> newFields = new ArrayList<Field>();
        boolean foundIt = false;
        int i = 0;
        while (i < this.fields.length) {
            Field field = this.fields[i];
            if (field.nameIndex() == nameIndex) {
                foundIt = true;
            } else {
                newFields.add(field);
            }
            ++i;
        }
        if (!foundIt) {
            String s = "No field with name index " + nameIndex + " in " + this.name();
            throw new IllegalArgumentException(s);
        }
        this.fields = newFields.toArray(new Field[0]);
    }

    public void deleteMethod(int nameIndex, int typeIndex) {
        ArrayList<Method> newMethods = new ArrayList<Method>();
        boolean foundIt = false;
        int i = 0;
        while (i < this.methods.length) {
            Method method = this.methods[i];
            if (method.nameIndex() == nameIndex && method.typeIndex() == typeIndex) {
                foundIt = true;
            } else {
                newMethods.add(method);
            }
            ++i;
        }
        if (!foundIt) {
            String s = "No method with name index " + nameIndex + " and type index " + typeIndex + " in " + this.name();
            throw new IllegalArgumentException(s);
        }
        this.methods = newMethods.toArray(new Method[0]);
    }

    public MethodInfo addNewMethod(int modifiers, int typeIndex, int nameIndex, int exceptionIndex, int[] exceptionTypeIndices, int codeIndex) {
        Exceptions exceptions = new Exceptions(this, exceptionIndex, exceptionTypeIndices);
        Code code = new Code(this, codeIndex);
        Attribute[] attributes = new Attribute[]{exceptions, code};
        Method method = new Method(this, modifiers, nameIndex, typeIndex, attributes, code, exceptions);
        Method[] methods = new Method[this.methods.length + 1];
        int i = 0;
        while (i < this.methods.length) {
            methods[i] = this.methods[i];
            ++i;
        }
        methods[this.methods.length] = method;
        this.methods = methods;
        return method;
    }

    public void print(PrintStream out) {
        this.print(new PrintWriter(out, true));
    }

    public void print(PrintWriter out) {
        out.print("(constants");
        int i = 0;
        while (i < this.constants.size()) {
            out.print("\n    " + i + ": " + this.constants.get(i));
            ++i;
        }
        out.println(")");
        out.println("(class " + this.classIndex() + ")");
        out.println("(super " + this.superclassIndex() + ")");
        out.print("(interfaces");
        i = 0;
        while (i < this.interfaces.length) {
            out.print("\n    " + i + ": " + this.interfaces[i]);
            ++i;
        }
        out.println(")");
        out.print("(modifiers");
        if ((this.modifiers & 1) != 0) {
            out.print(" PUBLIC");
        }
        if ((this.modifiers & 0x10) != 0) {
            out.print(" FINAL");
        }
        if ((this.modifiers & 0x20) != 0) {
            out.print(" SUPER");
        }
        if ((this.modifiers & 0x200) != 0) {
            out.print(" INTERFACE");
        }
        if ((this.modifiers & 0x400) != 0) {
            out.print(" ABSTRACT");
        }
        out.println(")");
        out.print("(fields");
        i = 0;
        while (i < this.fields.length) {
            out.print("\n    " + i + ": " + this.fields[i]);
            ++i;
        }
        out.println(")");
        out.print("(methods");
        i = 0;
        while (i < this.methods.length) {
            out.print("\n    " + i + ": " + this.methods[i]);
            ++i;
        }
        out.println(")");
    }

    public String toString() {
        return "(ClassFile " + this.name() + ")";
    }
}

