/*
 * Decompiled with CFR 0.152.
 */
package clear.dep.ftr;

import clear.dep.ftr.DepFtrToken;
import java.io.FileInputStream;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DepFtrXml {
    public static final String XML_TEMPLATE = "feature_template";
    public static final String XML_UNIGRAM = "unigram";
    public static final String XML_BIGRAM = "bigram";
    public static final String XML_TRIGRAM = "trigram";
    public static final String XML_FIELD = "field";
    public static final String XML_TOKEN = "token";
    public static final String XML_TOKEN_HD = "hd";
    public static final String XML_TOKEN_LM = "lm";
    public static final String XML_TOKEN_RM = "rm";
    public static final String XML_VISIBLE = "visible";
    public static final String XML_COMMENT = "comment";
    public static final String XML_FORM = "f";
    public static final String XML_LEMMA = "m";
    public static final String XML_POS = "p";
    public static final String XML_DEPREL = "d";
    public static final String XML_POS_POS = "pp";
    public static final String XML_POS_LEMMA = "pm";
    public static final String XML_LEMMA_POS = "mp";
    public static final String XML_LEMMA_LEMMA = "mm";
    public static final String XML_POS_POS_POS = "ppp";
    public static final char XML_LAMBDA = 'l';
    public static final char XML_BETA = 'b';
    public static final String XML_DELIM_REL = "_";
    public ArrayList<DepFtrToken[]> form_1gram;
    public ArrayList<DepFtrToken[]> lemma_1gram;
    public ArrayList<DepFtrToken[]> pos_1gram;
    public ArrayList<DepFtrToken[]> deprel_1gram;
    public ArrayList<DepFtrToken[]> pos_lemma_1gram;
    public ArrayList<DepFtrToken[]> pos_pos_2gram;
    public ArrayList<DepFtrToken[]> pos_lemma_2gram;
    public ArrayList<DepFtrToken[]> lemma_pos_2gram;
    public ArrayList<DepFtrToken[]> lemma_lemma_2gram;
    public ArrayList<DepFtrToken[]> pos_pos_pos_3gram;

    public DepFtrXml(String featureXml) {
        this.init(featureXml);
    }

    public void init(String featureXml) {
        DocumentBuilderFactory dFactory = DocumentBuilderFactory.newInstance();
        this.form_1gram = new ArrayList();
        this.lemma_1gram = new ArrayList();
        this.pos_1gram = new ArrayList();
        this.deprel_1gram = new ArrayList();
        this.pos_lemma_1gram = new ArrayList();
        this.pos_pos_2gram = new ArrayList();
        this.pos_lemma_2gram = new ArrayList();
        this.lemma_pos_2gram = new ArrayList();
        this.lemma_lemma_2gram = new ArrayList();
        this.pos_pos_pos_3gram = new ArrayList();
        try {
            DocumentBuilder builder = dFactory.newDocumentBuilder();
            Document doc = builder.parse(new FileInputStream(featureXml));
            NodeList unigram = doc.getElementsByTagName(XML_UNIGRAM);
            NodeList bigram = doc.getElementsByTagName(XML_BIGRAM);
            NodeList trigram = doc.getElementsByTagName(XML_TRIGRAM);
            this.initNgram(unigram, 1);
            this.initNgram(bigram, 2);
            this.initNgram(trigram, 3);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private void initNgram(NodeList lsNgram, int maxToken) throws Exception {
        int i = 0;
        while (i < lsNgram.getLength()) {
            Element eFeature = (Element)lsNgram.item(i);
            String visible = eFeature.getAttribute(XML_VISIBLE).trim();
            if (!visible.equals("false")) {
                DepFtrToken[] tokens = new DepFtrToken[maxToken];
                int n = 0;
                while (n < maxToken) {
                    String token = eFeature.getAttribute(XML_TOKEN + n).trim();
                    tokens[n] = this.initTokenTemplate(token);
                    ++n;
                }
                String field = eFeature.getAttribute(XML_FIELD).trim();
                if (maxToken == 1) {
                    if (field.equals(XML_FORM)) {
                        this.form_1gram.add(tokens);
                    } else if (field.equals(XML_LEMMA)) {
                        this.lemma_1gram.add(tokens);
                    } else if (field.equals(XML_POS)) {
                        this.pos_1gram.add(tokens);
                    } else if (field.equals(XML_DEPREL)) {
                        this.deprel_1gram.add(tokens);
                    } else if (field.equals(XML_POS_LEMMA)) {
                        this.pos_lemma_1gram.add(tokens);
                    } else {
                        this.xmlError(XML_FIELD, field);
                    }
                } else if (maxToken == 2) {
                    if (field.equals(XML_POS_POS)) {
                        this.pos_pos_2gram.add(tokens);
                    } else if (field.equals(XML_POS_LEMMA)) {
                        this.pos_lemma_2gram.add(tokens);
                    } else if (field.equals(XML_LEMMA_POS)) {
                        this.lemma_pos_2gram.add(tokens);
                    } else if (field.equals(XML_LEMMA_LEMMA)) {
                        this.lemma_lemma_2gram.add(tokens);
                    } else {
                        this.xmlError(XML_FIELD, field);
                    }
                } else if (maxToken == 3) {
                    if (field.equals(XML_POS_POS_POS)) {
                        this.pos_pos_pos_3gram.add(tokens);
                    } else {
                        this.xmlError(XML_FIELD, field);
                    }
                }
            }
            ++i;
        }
    }

    private DepFtrToken initTokenTemplate(String token) throws Exception {
        String[] aToken = token.split(XML_DELIM_REL);
        char type = aToken[0].charAt(0);
        if (type != 'l' && type != 'b') {
            this.xmlError(XML_TOKEN, token);
        }
        int offset = 0;
        if (aToken[0].length() >= 2) {
            offset = aToken[0].charAt(1) == '+' ? Integer.parseInt(aToken[0].substring(2)) : Integer.parseInt(aToken[0].substring(1));
        }
        if (aToken.length > 1) {
            if (!(aToken[1].equals(XML_TOKEN_HD) || aToken[1].equals(XML_TOKEN_LM) || aToken[1].equals(XML_TOKEN_RM))) {
                this.xmlError(XML_TOKEN, token);
            }
            return new DepFtrToken(type, offset, aToken[1]);
        }
        return new DepFtrToken(type, offset, null);
    }

    public void xmlError(String attr, String error) {
        System.err.println("Invalid <" + attr + ">: " + error);
        System.exit(1);
    }
}

