/*
 * Decompiled with CFR 0.152.
 */
package clear.engine;

import java.io.File;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AbstractEngine {
    protected final String TAG_COMMON = "common";
    protected final String TAG_COMMON_LANGUAGE = "language";
    protected final String TAG_COMMON_FORMAT = "format";
    protected final String TAG_COMMON_LEXICON_DIR = "lexicon_dir";
    protected final String TAG_COMMON_MODEL_FILE = "model_file";
    protected final String TAG_COMMON_FEATURE_XML = "feature_xml";
    protected String s_language = null;
    protected String s_format = null;
    protected String s_lexiconDir = null;
    protected String s_modelFile = null;
    protected String s_featureXml = null;
    protected Element e_config;

    public boolean initConfigElement(String configXml) {
        DocumentBuilderFactory dFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = dFactory.newDocumentBuilder();
            Document doc = builder.parse(new File(configXml));
            this.e_config = doc.getDocumentElement();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    protected boolean initCommonElements() {
        Element eCommon = this.getElement(this.e_config, "common");
        if (eCommon == null) {
            System.err.println("Error: <common> must be specified.");
            return false;
        }
        Element eLanguage = this.getElement(eCommon, "language");
        if (eLanguage == null) {
            System.err.println("Error: <common.language> must be specified.");
            return false;
        }
        this.s_language = eLanguage.getTextContent().trim();
        if (!(this.s_language.equals("ch") || this.s_language.equals("en") || this.s_language.equals("hi"))) {
            System.err.println("Error: invalid <common.language = " + this.s_language + ">.");
            return false;
        }
        Element eFormat = this.getElement(eCommon, "format");
        if (eFormat == null) {
            System.err.println("Error: <common.format> must be specified.");
            return false;
        }
        this.s_format = eFormat.getTextContent().trim();
        if (!(this.s_format.equals("raw") || this.s_format.equals("pos") || this.s_format.equals("dep") || this.s_format.equals("srl") || this.s_format.equals("conll"))) {
            System.err.println("Error: invalid <common.format = " + this.s_format + ">.");
            return false;
        }
        Element eConfigDir = this.getElement(eCommon, "lexicon_dir");
        if (eConfigDir == null) {
            System.err.println("Error: <common.lexicon_dir> must be specified.");
            return false;
        }
        this.s_lexiconDir = eConfigDir.getTextContent().trim();
        Element eModelFile = this.getElement(eCommon, "model_file");
        if (eModelFile == null) {
            System.err.println("Error: <common.model_file> must be specified.");
            return false;
        }
        this.s_modelFile = eModelFile.getTextContent().trim();
        Element eFeatureXml = this.getElement(eCommon, "feature_xml");
        if (eFeatureXml == null) {
            System.err.println("Error: <common.feature_xml> must be specified.");
            return false;
        }
        this.s_featureXml = eFeatureXml.getTextContent().trim();
        return true;
    }

    protected void printCommonConfig() {
        System.out.println("Configurations");
        System.out.println("- language   : " + this.s_language);
        System.out.println("- format     : " + this.s_format);
        System.out.println("- lexicon_dir: " + this.s_lexiconDir);
        System.out.println("- model_file : " + this.s_modelFile);
        System.out.println("- feature_xml: " + this.s_featureXml);
    }

    protected Element getElement(Element parent, String name) {
        NodeList list = parent.getElementsByTagName(name);
        return list.getLength() > 0 ? (Element)list.item(0) : null;
    }
}

