/*
 * Decompiled with CFR 0.152.
 */
package clear.engine;

import clear.dep.DepParser;
import clear.dep.DepTree;
import clear.engine.AbstractEngine;
import clear.reader.AbstractReader;
import clear.reader.CoNLLReader;
import clear.reader.DepReader;
import clear.reader.PosReader;
import clear.util.IOUtil;
import java.io.PrintStream;
import org.w3c.dom.Element;

public class DepPredict
extends AbstractEngine {
    protected final String TAG_PREDICT = "predict";
    protected final String TAG_PREDICT_POS_MODEL_FILE = "pos_model_file";
    protected final String TAG_PREDICT_MORPH_DICT_DIR = "morph_dict_dir";
    private String s_testFile = null;
    private String s_outputFile = null;
    private String s_configFile = null;
    private String s_posModelFile = null;
    private String s_morphDictDir = null;
    private byte i_flag = (byte)3;
    private int[] n_size_total = new int[10];
    private double[] d_time = new double[10];
    private double d_time_total = 0.0;

    public DepPredict(String[] args) {
        if (!this.initArgs(args)) {
            return;
        }
        if (!this.initConfigElement(this.s_configFile)) {
            return;
        }
        if (!this.initCommonElements()) {
            return;
        }
        if (!this.initPredictElements()) {
            return;
        }
        this.printCommonConfig();
        System.out.println();
        AbstractReader reader = null;
        reader = this.s_format.equals("pos") ? new PosReader(this.s_testFile, this.s_language, this.s_morphDictDir) : (this.s_format.equals("dep") ? new DepReader(this.s_testFile, false) : new CoNLLReader(this.s_testFile, false));
        System.out.println("Predict: " + this.s_outputFile);
        DepParser parser = new DepParser(this.s_lexiconDir, this.s_modelFile, this.s_featureXml, this.i_flag);
        PrintStream fout = IOUtil.createPrintFileStream(this.s_outputFile);
        int n = 0;
        while (true) {
            int index;
            long st = System.currentTimeMillis();
            DepTree tree = (DepTree)reader.nextTree();
            if (tree == null) break;
            parser.parse(tree);
            long et = System.currentTimeMillis();
            fout.println(tree + "\n");
            if (++n % 100 == 0) {
                System.out.print("\r- Parsing: " + n);
            }
            int n2 = index = tree.size() >= 101 ? 9 : (tree.size() - 1) / 10;
            this.d_time[n2] = this.d_time[n2] + (double)(et - st);
            this.d_time_total += (double)(et - st);
            int n3 = index;
            this.n_size_total[n3] = this.n_size_total[n3] + 1;
        }
        System.out.println("\r- Parsing: " + n);
        System.out.println("\nParsing time per sentence length:");
        int i = 0;
        while (i < this.d_time.length) {
            System.out.printf("<= %3d: %4.2f (ms)\n", (i + 1) * 10, this.d_time[i] / (double)this.n_size_total[i]);
            ++i;
        }
        System.out.printf("\nAverage parsing time: %4.2f (ms)\n", this.d_time_total / (double)n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean initArgs(String[] args) {
        if (args.length == 0 || args.length % 2 != 0) {
            this.printUsage();
            return false;
        }
        try {
            int i = 0;
            while (i < args.length) {
                if (args[i].equals("-t")) {
                    this.s_testFile = args[i + 1];
                } else if (args[i].equals("-o")) {
                    this.s_outputFile = args[i + 1];
                } else if (args[i].equals("-c")) {
                    this.s_configFile = args[i + 1];
                } else {
                    if (!args[i].equals("-f")) {
                        this.printUsage();
                        return false;
                    }
                    this.i_flag = Byte.parseByte(args[i + 1]);
                }
                i += 2;
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return false;
        }
        if (this.s_testFile == null) {
            System.err.println("Error: <test file> must be specified.");
            return false;
        }
        if (this.s_outputFile == null) {
            System.err.println("Error: <output file> must be specified.");
            return false;
        }
        if (this.s_configFile == null) {
            System.err.println("Error: <configure file> must be specified.");
            return false;
        }
        if (this.i_flag != 3 && this.i_flag != 4) {
            System.err.println("Error: invalid <flag = " + this.i_flag + ">.");
            return false;
        }
        return true;
    }

    protected boolean initPredictElements() {
        Element ePredict = this.getElement(this.e_config, "predict");
        if (ePredict == null) {
            if (this.s_format.equals("raw") || this.s_language.equals("en") && this.s_format.equals("pos")) {
                System.err.println("Error: <predict> must be specified.");
                return false;
            }
            return true;
        }
        Element ePosModelFile = this.getElement(ePredict, "pos_model_file");
        if (ePosModelFile != null) {
            this.s_posModelFile = ePosModelFile.getTextContent().trim();
        } else if (this.s_format.equals("raw")) {
            System.err.println("Error: <pos_model_file> must be specified for [" + this.s_format + "] format.");
            return false;
        }
        Element eMorphDictDir = this.getElement(ePredict, "morph_dict_dir");
        if (eMorphDictDir != null) {
            this.s_morphDictDir = eMorphDictDir.getTextContent().trim();
        } else if (this.s_language.equals("en") && (this.s_format.equals("raw") || this.s_format.equals("pos"))) {
            System.err.println("Error: <morph_dict_dir> must be specified for [" + this.s_format + "] format.");
            return false;
        }
        return true;
    }

    private void printUsage() {
        String usage = "Usage: java clear.engine.DepPredic -t <test file> -o <output file> -c <configuration file> [-f <flag = " + this.i_flag + ">]";
        System.out.println(usage);
        System.out.println("<flag> ::= 3: greedy search");
        System.out.println("           4: k-best search");
    }

    public static void main(String[] args) {
        new DepPredict(args);
    }
}

