/*
 * Decompiled with CFR 0.152.
 */
package clear.model;

import clear.model.AbstractModel;
import clear.util.tuple.JIntDoubleTuple;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;

public class LiblinearModel
extends AbstractModel {
    private double d_bias;

    public LiblinearModel(String modelFile) {
        try {
            BufferedReader fin = new BufferedReader(new FileReader(modelFile));
            String[] tmp = fin.readLine().split(" ");
            String solverType = tmp[1];
            tmp = fin.readLine().split(" ");
            this.n_labels = Integer.parseInt(tmp[1]);
            if (this.n_labels == 2 && !solverType.equals("MCSVM_CS")) {
                this.n_labels = 1;
            }
            tmp = fin.readLine().split(" ");
            this.i_labels = new int[this.n_labels];
            int i = 0;
            while (i < this.n_labels) {
                this.i_labels[i] = Integer.parseInt(tmp[i + 1]);
                ++i;
            }
            tmp = fin.readLine().split(" ");
            this.n_features = Integer.parseInt(tmp[1]);
            tmp = fin.readLine().split(" ");
            this.d_bias = Double.parseDouble(tmp[1]);
            if (this.d_bias >= 0.0) {
                ++this.n_features;
            }
            fin.readLine();
            this.d_weights = new float[this.n_features * this.n_labels];
            int[] buffer = new int[128];
            i = 0;
            while (i < this.n_features) {
                int j = 0;
                while (j < this.n_labels) {
                    int ch;
                    int index = i * this.n_labels + j;
                    int b = 0;
                    while ((ch = fin.read()) != 32) {
                        buffer[b++] = ch;
                    }
                    this.d_weights[index] = Float.parseFloat(new String(buffer, 0, b));
                    ++j;
                }
                if (i % 1000000 == 0) {
                    System.out.print(".");
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public JIntDoubleTuple predict(ArrayList<Integer> x) {
        double[] scores = this.getScores(x);
        JIntDoubleTuple max = new JIntDoubleTuple(this.i_labels[0], scores[0]);
        int i = 1;
        while (i < this.n_labels) {
            if (scores[i] > max.d) {
                max.set(this.i_labels[i], scores[i]);
            }
            ++i;
        }
        return max;
    }

    @Override
    public ArrayList<JIntDoubleTuple> predictAll(ArrayList<Integer> x) {
        double[] scores = this.getScores(x);
        ArrayList<JIntDoubleTuple> aRes = new ArrayList<JIntDoubleTuple>();
        int i = 0;
        while (i < this.n_labels) {
            block3: {
                int j = 0;
                while (j < aRes.size()) {
                    if (aRes.get((int)j).d < scores[i]) {
                        aRes.add(j, new JIntDoubleTuple(this.i_labels[i], scores[i]));
                        break block3;
                    }
                    ++j;
                }
                aRes.add(new JIntDoubleTuple(this.i_labels[i], scores[i]));
            }
            i = (short)(i + 1);
        }
        return aRes;
    }

    private double[] getScores(ArrayList<Integer> x) {
        double[] scores = new double[this.n_labels];
        for (int idx : x) {
            int i = 0;
            while (i < this.n_labels) {
                int n = i;
                scores[n] = scores[n] + (double)this.d_weights[(idx - 1) * this.n_labels + i];
                ++i;
            }
        }
        return scores;
    }
}

