/*
 * Decompiled with CFR 0.152.
 */
package clear.morph;

import clear.pos.PosEnLib;
import clear.util.IOUtil;
import clear.util.tuple.JObjectObjectTuple;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Scanner;
import java.util.StringTokenizer;

public class MorphEnAnalyzer {
    private final String FIELD_DELIM = "_";
    HashMap<String, String> m_noun_exc;
    HashMap<String, String> m_verb_exc;
    HashMap<String, String> m_adj_exc;
    HashMap<String, String> m_adv_exc;
    HashSet<String> s_noun_base;
    HashSet<String> s_verb_base;
    HashSet<String> s_adj_base;
    HashSet<String> s_ordinal;
    ArrayList<JObjectObjectTuple<String, String>> a_noun_rule;
    ArrayList<JObjectObjectTuple<String, String>> a_verb_rule;
    ArrayList<JObjectObjectTuple<String, String>> a_adj_rule;
    HashMap<String, String> m_abbr_rule;

    public MorphEnAnalyzer(String dataDir) {
        this.m_noun_exc = this.getExcecptionMap(String.valueOf(dataDir) + File.separator + "noun.exc");
        this.m_verb_exc = this.getExcecptionMap(String.valueOf(dataDir) + File.separator + "verb.exc");
        this.m_adj_exc = this.getExcecptionMap(String.valueOf(dataDir) + File.separator + "adj.exc");
        this.m_adv_exc = this.getExcecptionMap(String.valueOf(dataDir) + File.separator + "adv.exc");
        this.s_noun_base = IOUtil.getHashSet(String.valueOf(dataDir) + File.separator + "noun.txt");
        this.s_verb_base = IOUtil.getHashSet(String.valueOf(dataDir) + File.separator + "verb.txt");
        this.s_adj_base = IOUtil.getHashSet(String.valueOf(dataDir) + File.separator + "adj.txt");
        this.s_ordinal = IOUtil.getHashSet(String.valueOf(dataDir) + File.separator + "ordinal.txt");
        this.a_noun_rule = this.getRuleList(String.valueOf(dataDir) + File.separator + "noun.rule");
        this.a_verb_rule = this.getRuleList(String.valueOf(dataDir) + File.separator + "verb.rule");
        this.a_adj_rule = this.getRuleList(String.valueOf(dataDir) + File.separator + "adj.rule");
        this.m_abbr_rule = this.getAbbreviationMap(String.valueOf(dataDir) + File.separator + "abbr.rule");
    }

    private HashMap<String, String> getExcecptionMap(String filename) {
        HashMap<String, String> map = new HashMap<String, String>();
        Scanner scan = IOUtil.createFileScanner(filename);
        while (scan.hasNextLine()) {
            String base;
            StringTokenizer tok = new StringTokenizer(scan.nextLine());
            String exc = tok.hasMoreTokens() ? tok.nextToken() : null;
            String string = base = tok.hasMoreTokens() ? tok.nextToken() : null;
            if (exc == null || base == null) continue;
            map.put(exc, base);
            while (tok.hasMoreTokens()) {
                map.put(tok.nextToken(), base);
            }
        }
        return map;
    }

    private HashMap<String, String> getAbbreviationMap(String filename) {
        HashMap<String, String> map = new HashMap<String, String>();
        Scanner scan = IOUtil.createFileScanner(filename);
        while (scan.hasNextLine()) {
            StringTokenizer tok = new StringTokenizer(scan.nextLine());
            String abbr = tok.nextToken();
            String pos = tok.nextToken();
            String key = String.valueOf(abbr) + "_" + pos;
            String base = tok.nextToken();
            map.put(key, base);
        }
        return map;
    }

    private ArrayList<JObjectObjectTuple<String, String>> getRuleList(String filename) {
        ArrayList<JObjectObjectTuple<String, String>> list = new ArrayList<JObjectObjectTuple<String, String>>();
        Scanner scan = IOUtil.createFileScanner(filename);
        while (scan.hasNextLine()) {
            StringTokenizer tok = new StringTokenizer(scan.nextLine());
            String str0 = tok.nextToken();
            String str1 = tok.hasMoreTokens() ? tok.nextToken() : "";
            list.add(new JObjectObjectTuple<String, String>(str0, str1));
        }
        return list;
    }

    public String getLemma(String form, String pos) {
        String morphem = this.getException(form = form.toLowerCase(), pos);
        if (morphem != null) {
            return morphem;
        }
        morphem = this.getBase(form, pos);
        if (morphem != null) {
            return morphem;
        }
        morphem = this.getAbbreviation(form, pos);
        if (morphem != null) {
            return morphem;
        }
        morphem = this.getNumber(form, pos);
        if (morphem != null) {
            return morphem;
        }
        return form;
    }

    private String getException(String form, String pos) {
        if (PosEnLib.isNoun(pos)) {
            return this.m_noun_exc.get(form);
        }
        if (PosEnLib.isVerb(pos)) {
            return this.m_verb_exc.get(form);
        }
        if (PosEnLib.isAdjective(pos)) {
            return this.m_adj_exc.get(form);
        }
        if (PosEnLib.isAdverb(pos)) {
            return this.m_adv_exc.get(form);
        }
        return null;
    }

    private String getBase(String form, String pos) {
        if (PosEnLib.isNoun(pos)) {
            return this.getBaseAux(form, this.s_noun_base, this.a_noun_rule);
        }
        if (PosEnLib.isVerb(pos)) {
            return this.getBaseAux(form, this.s_verb_base, this.a_verb_rule);
        }
        if (PosEnLib.isAdjective(pos)) {
            return this.getBaseAux(form, this.s_adj_base, this.a_adj_rule);
        }
        return null;
    }

    private String getBaseAux(String form, HashSet<String> set, ArrayList<JObjectObjectTuple<String, String>> rule) {
        for (JObjectObjectTuple<String, String> tup : rule) {
            int offset;
            String base;
            if (!form.endsWith((String)tup.key) || !set.contains(base = String.valueOf(form.substring(0, offset = form.length() - ((String)tup.key).length())) + (String)tup.value)) continue;
            return base;
        }
        return null;
    }

    private String getAbbreviation(String form, String pos) {
        String key = String.valueOf(form) + "_" + pos;
        return this.m_abbr_rule.get(key);
    }

    private String getNumber(String form, String pos) {
        if (this.s_ordinal.contains(form)) {
            return "$#ORD#$";
        }
        String prevStr = "";
        String currStr = form;
        while (!prevStr.equals(currStr)) {
            prevStr = currStr;
            currStr = currStr.replaceAll("\\d%", "0");
            currStr = currStr.replaceAll("\\$\\d", "0");
            currStr = currStr.replaceAll("\\.\\d", "0");
            currStr = currStr.replaceAll(",\\d", "0");
            currStr = currStr.replaceAll(":\\d", "0");
        }
        if ((currStr = currStr.replaceAll("\\d+", "0")).equals("0st") || currStr.equals("0nd") || currStr.equals("0rd") || currStr.equals("0th")) {
            return "$#ORD#$";
        }
        return currStr.equals(form) ? null : currStr;
    }
}

