/*
 * Decompiled with CFR 0.152.
 */
package clear.pos;

import java.util.Arrays;
import java.util.HashSet;

public class PosEnLib {
    public static String[] PHRAE_POS_ARR = new String[]{"S", "SBAR", "SBARQ", "SINV", "SQ", "ADJP", "ADVP", "CONJP", "FRAG", "INTJ", "LST", "NAC", "NP", "NX", "PP", "PRN", "PRT", "QP", "RRC", "UCP", "VP", "WHADJP", "WHADVP", "WHNP", "WHPP", "X"};
    public static HashSet<String> PHRASE_POS_SET = new HashSet<String>(Arrays.asList(PHRAE_POS_ARR));
    public static String NOUN = "NN";
    public static String VERB = "VB";
    public static String ADJ = "JJ";
    public static String ADV = "RB";
    public static String MODAL = "MD";
    public static String WH_DET = "WDT";
    public static String WH_PRO = "WP";
    public static String WH_ADV = "WRB";
    public static String IN = "IN";

    public static boolean isNoun(String pos) {
        return pos.startsWith(NOUN);
    }

    public static boolean isVerb(String pos) {
        return pos.startsWith(VERB);
    }

    public static boolean isAdjective(String pos) {
        return pos.startsWith(ADJ);
    }

    public static boolean isAdverb(String pos) {
        return pos.startsWith(ADV);
    }

    public static boolean isModal(String pos) {
        return pos.equals(MODAL);
    }

    public static String cpos(String pos) {
        return pos.length() < 2 ? pos : pos.substring(0, 2);
    }

    public static boolean isPhrase(String pos) {
        return PHRASE_POS_SET.contains(pos);
    }
}

