/*
 * Decompiled with CFR 0.152.
 */
package clear.treebank;

import clear.dep.DepNode;
import clear.dep.DepTree;
import clear.morph.MorphEnAnalyzer;
import clear.treebank.TBEnLib;
import clear.treebank.TBHeadRule;
import clear.treebank.TBHeadRules;
import clear.treebank.TBNode;
import clear.treebank.TBTree;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;

public class TBEnConvert {
    public DepTree toDepTree(TBTree pTree, TBHeadRules headrules, MorphEnAnalyzer morph) {
        DepTree dTree = new DepTree();
        this.initDepTree(morph, dTree, pTree.getRootNode());
        this.setDepHeads(pTree, dTree, pTree.getRootNode(), headrules);
        this.setDepRoot(dTree);
        this.setEmptyCategory(pTree, dTree);
        DepTree copy = this.removeEmptyCategories(dTree);
        copy.projectizePunc();
        copy.checkTree();
        return copy;
    }

    private void initDepTree(MorphEnAnalyzer morph, DepTree dTree, TBNode curr) {
        if (curr.isPhrase()) {
            for (TBNode child : curr.getChildren()) {
                this.initDepTree(morph, dTree, child);
            }
        } else {
            DepNode node = new DepNode();
            node.id = curr.terminalId + 1;
            node.form = curr.form;
            node.pos = curr.pos;
            node.lemma = morph != null ? morph.getLemma(curr.form, curr.pos) : node.form.toLowerCase();
            dTree.add(node);
        }
    }

    private void setDepHeads(TBTree pTree, DepTree dTree, TBNode curr, TBHeadRules headrules) {
        if (!curr.isPhrase()) {
            return;
        }
        for (TBNode child : curr.getChildren()) {
            this.setDepHeads(pTree, dTree, child, headrules);
        }
        if (curr.isPos("TOP")) {
            return;
        }
        this.findHeads(curr, headrules);
        if (this.isCoordination(curr)) {
            this.setCoordination(pTree, dTree, curr);
        } else if (curr.isPos("NP|NX|NML")) {
            this.setApposition(pTree, dTree, curr);
        }
        this.setGap(pTree, dTree, curr);
        this.reconfigureHead(dTree, curr);
        this.setDepHeadsAux(pTree, dTree, curr);
    }

    private void findHeads(TBNode curr, TBHeadRules headrules) {
        TBHeadRule headrule = headrules.getHeadRule(curr.pos);
        ArrayList<TBNode> children = curr.getChildren();
        if (children.size() == 1) {
            curr.headId = children.get((int)0).headId;
            return;
        }
        String[] stringArray = headrule.rules;
        int n = headrule.rules.length;
        int n2 = 0;
        while (n2 < n) {
            int i;
            String rule = stringArray[n2];
            if (headrule.dir == -1) {
                i = 0;
                while (i < children.size()) {
                    if (this.findHeadsAux(curr, children.get(i), rule)) {
                        return;
                    }
                    ++i;
                }
            } else {
                i = children.size() - 1;
                while (i >= 0) {
                    if (this.findHeadsAux(curr, children.get(i), rule)) {
                        return;
                    }
                    --i;
                }
            }
            ++n2;
        }
        if (curr.headId < 0) {
            curr.headId = headrule.dir == -1 ? children.get((int)0).headId : children.get((int)(children.size() - 1)).headId;
        }
    }

    private boolean findHeadsAux(TBNode curr, TBNode child, String rule) {
        if (curr.isPos("NP") && (child.isTag("BNF") || child.isTag("DIR") || child.isTag("LOC") || child.isTag("MNR") || child.isTag("PRP") || child.isTag("TMP"))) {
            return false;
        }
        if (child.isRule(rule) && !TBEnLib.isPunctuation(child.pos) && !child.isEmptyCategoryRec() && !child.isPos("EDITED")) {
            curr.headId = child.headId;
            return true;
        }
        return false;
    }

    private boolean isCoordination(TBNode curr) {
        return curr.isPos("UCP") || curr.containsPos("CC") || curr.containsPos("CONJP") || curr.containsTag("ETC");
    }

    private void setCoordination(TBTree pTree, DepTree dTree, TBNode curr) {
        ArrayList<TBNode> children = curr.getChildren();
        int i = children.size() - 2;
        while (i >= 0) {
            block3: {
                TBNode prev;
                block4: {
                    TBNode conj = children.get(i);
                    if (!TBEnLib.isConjunction(conj.pos)) break block3;
                    prev = this.getConjunct(children, i, false, -1);
                    TBNode next = this.getConjunct(children, i, false, 1);
                    if (prev == null) break;
                    if (next == null) break block3;
                    if (this.setCoordinationAux(pTree, dTree, curr, conj, prev, next)) break block4;
                    prev = this.getConjunct(children, i, true, -1);
                    next = this.getConjunct(children, i, true, 1);
                    if (prev == null) break;
                    if (next == null) break block3;
                    this.setCoordinationAux(pTree, dTree, curr, conj, prev, next);
                }
                i = prev.childId;
            }
            --i;
        }
    }

    private TBNode getConjunct(ArrayList<TBNode> children, int id, boolean more, int dir) {
        String skip1 = "PRN|INTJ|EDITED|META|CODE";
        String skip2 = "ADVP|SBAR";
        int i = id + dir;
        while (i >= 0 && i < children.size()) {
            TBNode node = children.get(i);
            if (!(TBEnLib.isConjunction(node.pos) || TBEnLib.isPunctuation(node.pos) || node.isEmptyCategoryRec() || node.isPos(skip1) || more && node.isPos(skip2))) {
                return node;
            }
            i += dir;
        }
        return null;
    }

    private boolean setCoordinationAux(TBTree pTree, DepTree dTree, TBNode curr, TBNode conj, TBNode prev, TBNode next) {
        ArrayList<TBNode> children = curr.getChildren();
        if (curr.isPos("UCP") || prev.isPos(next.pos) || next.isTag("ETC") || TBEnLib.isWordConjunction(conj.pos) && next.childId == children.size() - 1 || TBEnLib.isNounLike(prev.pos) && TBEnLib.isNounLike(next.pos) || TBEnLib.isAdjectiveLike(prev.pos) && TBEnLib.isAdjectiveLike(next.pos) || curr.isPos("WHADVP") && TBEnLib.isWhAdverbLike(prev.pos) && TBEnLib.isWhAdverbLike(next.pos)) {
            TBNode node;
            int i = prev.childId + 1;
            while (i <= conj.childId) {
                node = children.get(i);
                this.setDependency(dTree, node.headId, prev.headId, this.getDeprel(pTree, curr, node));
                if (TBEnLib.isWordConjunction(node.pos)) {
                    prev = node;
                }
                ++i;
            }
            i = conj.childId + 1;
            while (i <= next.childId - 1) {
                node = children.get(i);
                this.setDependency(dTree, node.headId, next.headId, this.getDeprel(pTree, curr, node));
                ++i;
            }
            DepNode dNode = (DepNode)dTree.get(next.headId + 1);
            if (dNode.deprel.startsWith("GAP")) {
                if (TBEnLib.isWordConjunction(prev.pos)) {
                    this.setDependency(dTree, prev.headId, dNode.headId - 1, "COORD");
                    this.setDependency(dTree, next.headId, prev.headId, dNode.deprel);
                }
            } else {
                this.setDependency(dTree, next.headId, prev.headId, "CONJ");
            }
            return true;
        }
        return false;
    }

    private void setGap(TBTree pTree, DepTree dTree, TBNode curr) {
        ArrayList<TBNode> children = curr.getChildren();
        int i = children.size() - 1;
        while (i >= 0) {
            block8: {
                TBNode child = children.get(i);
                if (child.gapIndex != -1) {
                    int j = i - 1;
                    while (j >= 0) {
                        TBNode head = children.get(j);
                        if (head.coIndex == child.gapIndex || head.gapIndex == child.gapIndex) {
                            DepNode dNode = (DepNode)dTree.get(child.headId + 1);
                            if (dNode.isDeprel("CONJ")) {
                                dNode.deprel = "GAP";
                            } else {
                                this.setDependency(dTree, child.headId, head.headId, "GAP");
                            }
                            break block8;
                        }
                        --j;
                    }
                    ArrayList<TBNode> siblings = curr.getParent().getChildren();
                    int j2 = curr.childId - 1;
                    while (j2 >= 0) {
                        TBNode head = siblings.get(j2).getGapNode(child.gapIndex);
                        if (head != null) {
                            String deprel = this.getTagDeprel(pTree.getTerminalNodes().get(curr.headId).getParent());
                            deprel = deprel == null ? "" : "-" + deprel;
                            this.setDependency(dTree, curr.headId, head.headId, "GAP" + deprel);
                            return;
                        }
                        --j2;
                    }
                }
            }
            --i;
        }
    }

    private void setApposition(TBTree pTree, DepTree dTree, TBNode curr) {
        ArrayList<TBNode> children = curr.getChildren();
        int i = children.size() - 3;
        while (i >= 0) {
            TBNode fst = children.get(i);
            TBNode mid = children.get(i + 1);
            TBNode lst = children.get(i + 2);
            if (fst.isPos("NP") && mid.isPos(",") && lst.isPos("NP")) {
                this.setDependency(dTree, lst.headId, fst.headId, "APPO");
            }
            --i;
        }
    }

    private void setDepRoot(DepTree tree) {
        int i = 1;
        while (i < tree.size()) {
            DepNode node = (DepNode)tree.get(i);
            if (node.headId == -2) {
                node.setHead(0, "ROOT", 0.0);
            }
            ++i;
        }
    }

    private void reconfigureHead(DepTree tree, TBNode curr) {
        BitSet set = curr.getSubTerminalBitSet();
        DepNode tmp = (DepNode)tree.get(curr.headId + 1);
        while (tmp.hasHead && set.get(tmp.headId - 1)) {
            tmp = (DepNode)tree.get(tmp.headId);
        }
        curr.headId = tmp.id - 1;
    }

    private void setDepHeadsAux(TBTree pTree, DepTree dTree, TBNode curr) {
        ArrayList<TBNode> children = curr.getChildren();
        int i = 0;
        while (i < children.size()) {
            block5: {
                TBNode child = children.get(i);
                if (child.headId != curr.headId && !this.hasHead(dTree, child.headId)) {
                    if (child.isPos("HYPH")) {
                        int j = i - 1;
                        while (j >= 0) {
                            TBNode prev = children.get(j);
                            if (!prev.isEmptyCategoryRec() && !TBEnLib.isPunctuation(prev.pos)) {
                                this.setDependency(dTree, child.headId, prev.headId, "P");
                                break block5;
                            }
                            --j;
                        }
                    }
                    String deprel = this.getDeprel(pTree, curr, child);
                    this.setDependency(dTree, child.headId, curr.headId, deprel);
                }
            }
            ++i;
        }
    }

    private String getDeprel(TBTree pTree, TBNode parent, TBNode child) {
        TBNode p = pTree.getTerminalNodes().get(parent.headId);
        TBNode c = pTree.getTerminalNodes().get(child.headId);
        String deprel = this.getTagDeprel(child);
        if (deprel != null) {
            return deprel;
        }
        deprel = this.getObjectDeprel(parent, child, c);
        if (deprel != null) {
            return deprel;
        }
        if (TBEnLib.isWordConjunction(child.pos)) {
            return "COORD";
        }
        if (TBEnLib.isPunctuation(child.pos)) {
            return "P";
        }
        if (child.isPos("PRN|META")) {
            return child.pos;
        }
        if ((parent.isPos("VP") || TBEnLib.isSentence(parent.pos)) && child.isPos("PP|ADVP|SBAR|RB")) {
            return "ADV";
        }
        if (parent.isPos("VP") && (child.isPos("PRT") || c.isPos("RP"))) {
            return "PRT";
        }
        if (p.isPos("TO") && child.isPos("VP")) {
            return "IM";
        }
        if (parent.isPos("VP|SQ|SINV") && child.isPos("VP")) {
            return "VC";
        }
        if (parent.isPos("SBAR") && p.isPos("IN|TO|DT")) {
            return "SUB";
        }
        if (parent.isPos("NP|NX|NAC|NML|WHNP")) {
            return "NMOD";
        }
        if (parent.isPos("ADJP|ADVP|WHADJP|WHADVP")) {
            return "AMOD";
        }
        if (parent.isPos("PP|WHPP")) {
            return "PMOD";
        }
        if (parent.isPos("QP")) {
            return "QMOD";
        }
        if (child.isPos("INTJ") || c.isPos("UH")) {
            return "INTJ";
        }
        if (child.isPos("EDITED")) {
            return "EDIT";
        }
        if (child.isPos("CIT")) {
            return "CIT";
        }
        if (child.isPos("ADVP") || c.isPos("RB")) {
            return "ADV";
        }
        if (TBEnLib.isNounLike(parent.pos)) {
            return "NMOD";
        }
        return "DEP";
    }

    private String getTagDeprel(TBNode child) {
        if (child.isTag("SBJ")) {
            return "SBJ";
        }
        if (child.isPos("PP") && child.containsTag("LGS")) {
            return "LGS";
        }
        if (child.isTag("DTV")) {
            return "DTV";
        }
        if (child.isTag("EXT")) {
            return "EXT";
        }
        if (child.isTag("LOC")) {
            return "LOC";
        }
        if (child.isTag("TMP")) {
            return "TMP";
        }
        if (child.isPos("PP") && child.isTag("BNF")) {
            return "BNF";
        }
        if (child.isTag("DIR")) {
            return "DIR";
        }
        if (child.isTag("MNR")) {
            return "MNR";
        }
        if (child.isTag("PRP")) {
            return "PRP";
        }
        if (child.isTag("SEZ")) {
            return "SEZ";
        }
        if (child.isTag("VOC")) {
            return "VOC";
        }
        if (child.isTag("PRD")) {
            return "PRD";
        }
        if (child.isTag("ADV")) {
            return "ADV";
        }
        return null;
    }

    private String getObjectDeprel(TBNode parent, TBNode child, TBNode c) {
        if (!parent.isPos("VP")) {
            return null;
        }
        if (child.isPos("NP") || child.isPos("SBAR") && !c.form.toLowerCase().matches("as|because|for|since|with") || child.isPos("S|SQ|SINV|SBARQ")) {
            return c.isPos("TO|VBG|VBN") ? "OPRD" : "OBJ";
        }
        if (child.isPos("UCP") && (child.isPos("NP") || child.isPos("SBAR") && !c.form.toLowerCase().matches("as|because|for|since|with") || child.isPos("S|SQ|SINV|SBARQ"))) {
            return c.isPos("TO|VBG|VBN") ? "OPRD" : "OBJ";
        }
        return null;
    }

    private void setEmptyCategory(TBTree pTree, DepTree dTree) {
        HashSet<String> sRNR = new HashSet<String>();
        int i = dTree.size() - 1;
        while (i >= 0) {
            block6: {
                DepNode ante;
                DepNode ec;
                block8: {
                    block7: {
                        int coIndex;
                        TBNode antecedent;
                        String[] tmp;
                        ec = (DepNode)dTree.get(i);
                        if (!ec.form.startsWith("*EXP*") && !ec.form.startsWith("*ICH*") && !ec.form.startsWith("*PPA*") && !ec.form.startsWith("*RNR*") && !ec.form.startsWith("*T*") || (tmp = ec.form.split("-")).length <= 1 || !tmp[1].matches("\\d*") || (antecedent = pTree.getAntecedent(coIndex = Integer.parseInt(tmp[1]))) == null || (ante = (DepNode)dTree.get(antecedent.headId + 1)).isPos("-NONE-") || ante.id == ec.headId) break block6;
                        if (!ec.form.startsWith("*EXP*")) break block7;
                        ante.deprel = "EXTR";
                        break block6;
                    }
                    if (!ec.form.startsWith("*RNR*")) break block8;
                    if (sRNR.contains(ec.form)) break block6;
                    sRNR.add(ec.form);
                }
                if (dTree.isAncestor(ante.id, ec.headId)) {
                    for (DepNode node : dTree.getDependents(ante.id)) {
                        if (node.id != ec.headId && !dTree.isAncestor(node.id, ec.headId)) continue;
                        node.setHead(ante.headId, ante.deprel, 1.0);
                        break;
                    }
                }
                ante.setHead(ec.headId, ec.deprel, 1.0);
            }
            --i;
        }
    }

    private DepTree removeEmptyCategories(DepTree tree) {
        DepNode node;
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        int i = 0;
        int j = 0;
        while (i < tree.size()) {
            node = (DepNode)tree.get(i);
            map.put(i, j);
            if (!node.isPos("-NONE-")) {
                ++j;
            }
            ++i;
        }
        DepTree copy = new DepTree();
        int i2 = 1;
        while (i2 < tree.size()) {
            node = (DepNode)tree.get(i2);
            if (!node.isPos("-NONE-")) {
                node.id = (Integer)map.get(node.id);
                node.headId = (Integer)map.get(node.headId);
                copy.add(node);
            }
            ++i2;
        }
        return copy;
    }

    private void setDependency(DepTree tree, int currId, int headId, String deprel) {
        tree.setHead(currId + 1, headId + 1, deprel, 1.0);
    }

    private boolean hasHead(DepTree tree, int currId) {
        return ((DepNode)tree.get((int)(currId + 1))).hasHead;
    }
}

