/*
 * Decompiled with CFR 0.152.
 */
package clear.util;

import com.carrotsearch.hppc.ObjectIntOpenHashMap;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Scanner;

public class IOUtil {
    public static BufferedReader createBufferedFileReader(String filename) {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), "UTF-8"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return reader;
    }

    public static Scanner createFileScanner(String filename) {
        return new Scanner(IOUtil.createBufferedFileReader(filename));
    }

    public static ArrayList<String> getArrayList(String filename) {
        ArrayList<String> arr = new ArrayList<String>();
        try {
            String line;
            BufferedReader fin = IOUtil.createBufferedFileReader(filename);
            while ((line = fin.readLine()) != null) {
                arr.add(line.trim());
            }
            arr.trimToSize();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return arr;
    }

    public static HashSet<String> getHashSet(String filename) {
        HashSet<String> set = new HashSet<String>();
        try {
            String line;
            BufferedReader fin = IOUtil.createBufferedFileReader(filename);
            while ((line = fin.readLine()) != null) {
                set.add(line.trim());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return set;
    }

    public static ObjectIntOpenHashMap<String> getHashMap(String filename, int beginId) {
        ObjectIntOpenHashMap<String> map = new ObjectIntOpenHashMap<String>();
        try {
            String line;
            BufferedReader fin = IOUtil.createBufferedFileReader(filename);
            int i = beginId;
            while ((line = fin.readLine()) != null) {
                map.put(line.trim(), i);
                ++i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return map;
    }

    public static ObjectIntOpenHashMap<String> getTStringIntHashMap(String filename, String delim) {
        ObjectIntOpenHashMap<String> map = new ObjectIntOpenHashMap<String>();
        try {
            String line;
            BufferedReader fin = IOUtil.createBufferedFileReader(filename);
            while ((line = fin.readLine()) != null) {
                String[] ls = line.split(delim);
                map.put(ls[0], Integer.parseInt(ls[1]));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    public static PrintStream createPrintFileStream(String filename) {
        PrintStream fout = null;
        try {
            fout = new PrintStream(filename, "UTF-8");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fout;
    }

    public static void printFile(HashSet<String> set, String outputFile) {
        PrintStream fout = IOUtil.createPrintFileStream(outputFile);
        for (String item : set) {
            fout.println(item);
        }
    }

    public static void printFile(ObjectIntOpenHashMap<String> map, String outputFile) {
        PrintStream fout = IOUtil.createPrintFileStream(outputFile);
        for (ObjectCursor item : map.keySet()) {
            fout.println((String)item.value);
        }
    }

    public static void printFile(ObjectIntOpenHashMap<String> map, String outputFile, int cutoff) {
        PrintStream fout = IOUtil.createPrintFileStream(outputFile);
        for (ObjectCursor key : map.keySet()) {
            if (map.get((String)key.value) <= cutoff) continue;
            fout.println((String)key.value);
        }
    }
}

