/*
 * Decompiled with CFR 0.152.
 */
package clear.util;

import clear.util.IOUtil;
import java.util.Scanner;
import java.util.StringTokenizer;

public class JFileTokenizer {
    public static final String WHITE = " \t\n\r\f";
    private Scanner mb_scan;
    private StringTokenizer mb_tok;
    private String mb_delim;
    private boolean mb_returnDelims;
    private int mb_numLines;

    public JFileTokenizer(String filename) {
        this.init(filename, WHITE, false);
    }

    public JFileTokenizer(String filename, String delim) {
        this.init(filename, delim, false);
    }

    public JFileTokenizer(String filename, String delim, boolean returnDelims) {
        this.init(filename, delim, returnDelims);
    }

    private void init(String filename, String delim, boolean returnDelims) {
        this.mb_scan = IOUtil.createFileScanner(filename);
        this.mb_delim = delim;
        this.mb_returnDelims = returnDelims;
        this.mb_numLines = 0;
        this.initTokenizer();
    }

    private boolean initTokenizer() {
        if (this.mb_scan.hasNextLine()) {
            this.mb_tok = new StringTokenizer(this.mb_scan.nextLine(), this.mb_delim, this.mb_returnDelims);
            ++this.mb_numLines;
            return true;
        }
        return false;
    }

    public boolean hasMoreTokens() {
        if (this.mb_tok.hasMoreTokens()) {
            return true;
        }
        if (this.initTokenizer()) {
            return this.hasMoreTokens();
        }
        return false;
    }

    public String nextToken() {
        if (this.hasMoreTokens()) {
            return this.mb_tok.nextToken();
        }
        return null;
    }

    public int getLineNumber() {
        return this.mb_numLines;
    }

    public void flushLine() {
        while (this.mb_tok.hasMoreTokens()) {
            this.mb_tok.nextToken();
        }
    }

    public void close() {
        this.mb_scan.close();
    }
}

