/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractByteCollection;
import com.carrotsearch.hppc.ArraySizingStrategy;
import com.carrotsearch.hppc.BoundedProportionalArraySizingStrategy;
import com.carrotsearch.hppc.ByteContainer;
import com.carrotsearch.hppc.ByteIndexedContainer;
import com.carrotsearch.hppc.cursors.ByteCursor;
import com.carrotsearch.hppc.hash.ByteHashFunction;
import com.carrotsearch.hppc.predicates.BytePredicate;
import com.carrotsearch.hppc.procedures.ByteProcedure;
import java.util.Arrays;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByteArrayList
extends AbstractByteCollection
implements ByteIndexedContainer {
    public static final int DEFAULT_CAPACITY = 5;
    private static final Object EMPTY = new byte[0];
    public byte[] buffer;
    public int elementsCount;
    protected final ArraySizingStrategy resizer;
    public final ByteHashFunction hashFunction;

    public ByteArrayList() {
        this(5);
    }

    public ByteArrayList(int initialCapacity) {
        this(initialCapacity, new BoundedProportionalArraySizingStrategy());
    }

    public ByteArrayList(int initialCapacity, ArraySizingStrategy resizer) {
        this(initialCapacity, resizer, new ByteHashFunction());
    }

    public ByteArrayList(int initialCapacity, ArraySizingStrategy resizer, ByteHashFunction hashFunction) {
        assert (initialCapacity >= 0) : "initialCapacity must be >= 0: " + initialCapacity;
        assert (resizer != null);
        assert (hashFunction != null);
        this.hashFunction = hashFunction;
        this.resizer = resizer;
        this.ensureBufferSpace(resizer.round(initialCapacity));
    }

    public ByteArrayList(ByteContainer container) {
        this(container.size());
        this.addAll(container);
    }

    @Override
    public void add(byte e1) {
        this.ensureBufferSpace(1);
        this.buffer[this.elementsCount++] = e1;
    }

    public final void add(byte e1, byte e2) {
        this.ensureBufferSpace(2);
        this.buffer[this.elementsCount++] = e1;
        this.buffer[this.elementsCount++] = e2;
    }

    public final void add(byte[] elements, int start, int length) {
        assert (length >= 0) : "Length must be >= 0";
        this.ensureBufferSpace(length);
        System.arraycopy(elements, start, this.buffer, this.elementsCount, length);
        this.elementsCount += length;
    }

    public final void add(byte ... elements) {
        this.add(elements, 0, elements.length);
    }

    public final int addAll(ByteContainer container) {
        int size = container.size();
        this.ensureBufferSpace(size);
        for (ByteCursor cursor : container) {
            this.add(cursor.value);
        }
        return size;
    }

    @Override
    public final void insert(int index, byte e1) {
        assert (index >= 0 && index <= this.size()) : "Index " + index + " out of bounds [" + 0 + ", " + this.size() + "].";
        this.ensureBufferSpace(1);
        System.arraycopy(this.buffer, index, this.buffer, index + 1, this.elementsCount - index);
        this.buffer[index] = e1;
        ++this.elementsCount;
    }

    @Override
    public final byte get(int index) {
        assert (index >= 0 && index < this.size()) : "Index " + index + " out of bounds [" + 0 + ", " + this.size() + ").";
        return this.buffer[index];
    }

    @Override
    public final byte set(int index, byte e1) {
        assert (index >= 0 && index < this.size()) : "Index " + index + " out of bounds [" + 0 + ", " + this.size() + ").";
        byte v = this.buffer[index];
        this.buffer[index] = e1;
        return v;
    }

    @Override
    public final byte remove(int index) {
        assert (index >= 0 && index < this.size()) : "Index " + index + " out of bounds [" + 0 + ", " + this.size() + ").";
        byte v = this.buffer[index];
        if (index + 1 < this.elementsCount) {
            System.arraycopy(this.buffer, index + 1, this.buffer, index, this.elementsCount - index - 1);
        }
        --this.elementsCount;
        this.buffer[this.elementsCount] = 0;
        return v;
    }

    @Override
    public final void removeRange(int fromIndex, int toIndex) {
        assert (fromIndex >= 0 && fromIndex <= this.size()) : "Index " + fromIndex + " out of bounds [" + 0 + ", " + this.size() + ").";
        assert (toIndex >= 0 && toIndex <= this.size()) : "Index " + toIndex + " out of bounds [" + 0 + ", " + this.size() + "].";
        assert (fromIndex <= toIndex) : "fromIndex must be <= toIndex: " + fromIndex + ", " + toIndex;
        System.arraycopy(this.buffer, toIndex, this.buffer, fromIndex, this.elementsCount - toIndex);
        int count = toIndex - fromIndex;
        this.elementsCount -= count;
        Arrays.fill(this.buffer, this.elementsCount, this.elementsCount + count, (byte)0);
    }

    @Override
    public final int removeFirstOccurrence(byte e1) {
        int index = this.indexOf(e1);
        if (index >= 0) {
            this.remove(index);
        }
        return index;
    }

    @Override
    public final int removeLastOccurrence(byte e1) {
        int index = this.lastIndexOf(e1);
        if (index >= 0) {
            this.remove(index);
        }
        return index;
    }

    @Override
    public final int removeAllOccurrences(byte e1) {
        int to = 0;
        for (int from = 0; from < this.elementsCount; ++from) {
            if (e1 == this.buffer[from]) {
                this.buffer[from] = 0;
                continue;
            }
            if (to != from) {
                this.buffer[to] = this.buffer[from];
                this.buffer[from] = 0;
            }
            ++to;
        }
        int deleted = this.elementsCount - to;
        this.elementsCount = to;
        return deleted;
    }

    @Override
    public final boolean contains(byte e1) {
        return this.indexOf(e1) >= 0;
    }

    @Override
    public final int indexOf(byte e1) {
        for (int i = 0; i < this.elementsCount; ++i) {
            if (e1 != this.buffer[i]) continue;
            return i;
        }
        return -1;
    }

    @Override
    public final int lastIndexOf(byte e1) {
        for (int i = this.elementsCount - 1; i >= 0; --i) {
            if (e1 != this.buffer[i]) continue;
            return i;
        }
        return -1;
    }

    @Override
    public final boolean isEmpty() {
        return this.elementsCount == 0;
    }

    public final void ensureCapacity(int minCapacity) {
        if (minCapacity > this.buffer.length) {
            this.ensureBufferSpace(minCapacity - this.size());
        }
    }

    protected final void ensureBufferSpace(int expectedAdditions) {
        int bufferLen;
        int n = bufferLen = this.buffer == null ? 0 : this.buffer.length;
        if (this.elementsCount + expectedAdditions >= bufferLen) {
            int newSize = this.resizer.grow(bufferLen, this.elementsCount, expectedAdditions);
            assert (newSize >= this.elementsCount + expectedAdditions) : "Resizer failed to return sensible new size: " + newSize + " <= " + (this.elementsCount + expectedAdditions);
            byte[] newBuffer = new byte[newSize];
            if (bufferLen > 0) {
                System.arraycopy(this.buffer, 0, newBuffer, 0, this.buffer.length);
            }
            this.buffer = newBuffer;
        }
    }

    public void resize(int newSize) {
        if (newSize <= this.buffer.length) {
            if (newSize < this.elementsCount) {
                Arrays.fill(this.buffer, newSize, this.elementsCount, (byte)0);
            } else {
                Arrays.fill(this.buffer, this.elementsCount, newSize, (byte)0);
            }
        } else {
            this.ensureCapacity(newSize);
        }
        this.elementsCount = newSize;
    }

    @Override
    public final int size() {
        return this.elementsCount;
    }

    public final void trimToSize() {
        if (this.size() != this.buffer.length) {
            this.buffer = this.toArray();
        }
    }

    @Override
    public final void clear() {
        this.elementsCount = 0;
    }

    public final void release() {
        this.clear();
        this.buffer = (byte[])EMPTY;
    }

    @Override
    public final byte[] toArray() {
        byte[] cloned = new byte[this.elementsCount];
        System.arraycopy(this.buffer, 0, cloned, 0, this.elementsCount);
        return cloned;
    }

    @Override
    public int hashCode() {
        int h = 1;
        int max = this.elementsCount;
        for (int i = 0; i < max; ++i) {
            h = 31 * h + this.hashFunction.hash(this.buffer[i]);
        }
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj instanceof ByteArrayList) {
                ByteArrayList other = (ByteArrayList)obj;
                return other.size() == this.size() && this.rangeEquals(other.buffer, this.buffer, this.size());
            }
            if (obj instanceof ByteIndexedContainer) {
                ByteIndexedContainer other = (ByteIndexedContainer)obj;
                return other.size() == this.size() && this.allIndexesEqual(this, other, this.size());
            }
        }
        return false;
    }

    private boolean rangeEquals(byte[] b1, byte[] b2, int length) {
        for (int i = 0; i < length; ++i) {
            if (b1[i] == b2[i]) continue;
            return false;
        }
        return true;
    }

    private boolean allIndexesEqual(ByteIndexedContainer b1, ByteIndexedContainer b2, int length) {
        for (int i = 0; i < length; ++i) {
            byte o2;
            byte o1 = b1.get(i);
            if (o1 == (o2 = b2.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<ByteCursor> iterator() {
        return new ValueIterator(this.buffer, 0, this.size() - 1);
    }

    @Override
    public void forEach(ByteProcedure procedure) {
        this.forEach(procedure, 0, this.size());
    }

    public void forEach(ByteProcedure procedure, int fromIndex, int toIndex) {
        assert (fromIndex >= 0 && fromIndex <= this.size()) : "Index " + fromIndex + " out of bounds [" + 0 + ", " + this.size() + ").";
        assert (toIndex >= 0 && toIndex <= this.size()) : "Index " + toIndex + " out of bounds [" + 0 + ", " + this.size() + "].";
        assert (fromIndex <= toIndex) : "fromIndex must be <= toIndex: " + fromIndex + ", " + toIndex;
        byte[] buffer = this.buffer;
        for (int i = fromIndex; i < toIndex; ++i) {
            procedure.apply(buffer[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int removeAll(BytePredicate predicate) {
        int from;
        int elementsCount = this.elementsCount;
        int to = 0;
        try {
            for (from = 0; from < elementsCount; ++from) {
                if (predicate.apply(this.buffer[from])) {
                    this.buffer[from] = 0;
                    continue;
                }
                if (to != from) {
                    this.buffer[to] = this.buffer[from];
                    this.buffer[from] = 0;
                }
                ++to;
            }
        }
        finally {
            while (from < elementsCount) {
                if (to != from) {
                    this.buffer[to] = this.buffer[from];
                    this.buffer[from] = 0;
                }
                ++to;
                ++from;
            }
            this.elementsCount = to;
        }
        return elementsCount - to;
    }

    @Override
    public void forEach(BytePredicate predicate) {
        this.forEach(predicate, 0, this.size());
    }

    public void forEach(BytePredicate predicate, int fromIndex, int toIndex) {
        assert (fromIndex >= 0 && fromIndex <= this.size()) : "Index " + fromIndex + " out of bounds [" + 0 + ", " + this.size() + ").";
        assert (toIndex >= 0 && toIndex <= this.size()) : "Index " + toIndex + " out of bounds [" + 0 + ", " + this.size() + "].";
        assert (fromIndex <= toIndex) : "fromIndex must be <= toIndex: " + fromIndex + ", " + toIndex;
        byte[] buffer = this.buffer;
        for (int i = fromIndex; i < toIndex && predicate.apply(buffer[i]); ++i) {
        }
    }

    public static ByteArrayList from(byte ... elements) {
        ByteArrayList list = new ByteArrayList(elements.length);
        list.add(elements);
        return list;
    }

    public static ByteArrayList from(ByteContainer container) {
        return new ByteArrayList(container);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ValueIterator
    implements Iterator<ByteCursor> {
        private final ByteCursor cursor;
        private final int lastIndex;
        private final byte[] buffer;

        public ValueIterator(byte[] buffer, int startIndex, int endIndex) {
            this.buffer = buffer;
            this.cursor = new ByteCursor();
            this.cursor.index = startIndex - 1;
            this.lastIndex = endIndex;
        }

        @Override
        public boolean hasNext() {
            return this.cursor.index < this.lastIndex;
        }

        @Override
        public ByteCursor next() {
            assert (this.cursor.index <= this.lastIndex);
            ++this.cursor.index;
            this.cursor.value = this.buffer[this.cursor.index];
            return this.cursor;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

