/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractCharCollection;
import com.carrotsearch.hppc.BitUtil;
import com.carrotsearch.hppc.CharCharAssociativeContainer;
import com.carrotsearch.hppc.CharCharMap;
import com.carrotsearch.hppc.CharContainer;
import com.carrotsearch.hppc.CharLookupContainer;
import com.carrotsearch.hppc.cursors.CharCharCursor;
import com.carrotsearch.hppc.cursors.CharCursor;
import com.carrotsearch.hppc.hash.CharHashFunction;
import com.carrotsearch.hppc.hash.CharMurmurHash;
import com.carrotsearch.hppc.predicates.CharPredicate;
import com.carrotsearch.hppc.procedures.CharCharProcedure;
import com.carrotsearch.hppc.procedures.CharProcedure;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharCharOpenHashMap
implements CharCharMap {
    public static final int DEFAULT_CAPACITY = 16;
    public static final int MIN_CAPACITY = 4;
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;
    public static final byte EMPTY = 0;
    public static final byte DELETED = 1;
    public static final byte ASSIGNED = 2;
    public char[] keys;
    public char[] values;
    public byte[] states;
    public int deleted;
    public int assigned;
    public final float loadFactor;
    private int resizeThreshold;
    private int lastSlot;
    public final CharHashFunction keyHashFunction;
    public final CharHashFunction valueHashFunction;
    private KeySet keySetView;

    public CharCharOpenHashMap() {
        this(16);
    }

    public CharCharOpenHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public CharCharOpenHashMap(int initialCapacity, float loadFactor) {
        this(initialCapacity, loadFactor, new CharMurmurHash());
    }

    public CharCharOpenHashMap(int initialCapacity, float loadFactor, CharHashFunction keyHashFunction) {
        this(initialCapacity, loadFactor, keyHashFunction, new CharHashFunction());
    }

    public CharCharOpenHashMap(int initialCapacity, float loadFactor, CharHashFunction keyHashFunction, CharHashFunction valueHashFunction) {
        initialCapacity = Math.max(initialCapacity, 4);
        assert (initialCapacity > 0) : "Initial capacity must be between (0, 2147483647].";
        assert (loadFactor > 0.0f && loadFactor <= 1.0f) : "Load factor must be between (0, 1].";
        this.valueHashFunction = valueHashFunction;
        this.keyHashFunction = keyHashFunction;
        this.loadFactor = loadFactor;
        this.allocateBuffers(this.roundCapacity(initialCapacity));
    }

    public CharCharOpenHashMap(CharCharAssociativeContainer container) {
        this((int)((float)container.size() * 1.75f));
        this.putAll(container);
    }

    @Override
    public char put(char key, char value) {
        int slot;
        byte state;
        if (this.assigned + this.deleted >= this.resizeThreshold) {
            this.expandAndRehash();
        }
        if ((state = this.states[slot = this.slotFor(key)]) != 2) {
            ++this.assigned;
        }
        if (state == 1) {
            --this.deleted;
        }
        char oldValue = this.values[slot];
        this.keys[slot] = key;
        this.values[slot] = value;
        this.states[slot] = 2;
        return oldValue;
    }

    @Override
    public final int putAll(CharCharAssociativeContainer container) {
        int count = this.assigned;
        for (CharCharCursor c : container) {
            this.put(c.key, c.value);
        }
        return this.assigned - count;
    }

    public final boolean putIfAbsent(char key, char value) {
        if (!this.containsKey(key)) {
            this.put(key, value);
            return true;
        }
        return false;
    }

    public final char putOrAdd(char key, char putValue, char additionValue) {
        int slot;
        byte state;
        if (this.assigned + this.deleted >= this.resizeThreshold) {
            this.expandAndRehash();
        }
        if ((state = this.states[slot = this.slotFor(key)]) == 2) {
            int n = slot;
            char c = (char)(this.values[n] + additionValue);
            this.values[n] = c;
            return c;
        }
        ++this.assigned;
        if (state == 1) {
            --this.deleted;
        }
        this.states[slot] = 2;
        this.keys[slot] = key;
        this.values[slot] = putValue;
        return this.values[slot];
    }

    private void expandAndRehash() {
        char[] oldKeys = this.keys;
        char[] oldValues = this.values;
        byte[] oldStates = this.states;
        if (this.assigned >= this.resizeThreshold) {
            this.allocateBuffers(this.nextCapacity(this.keys.length));
        } else {
            this.allocateBuffers(this.values.length);
        }
        for (int i = 0; i < oldStates.length; ++i) {
            if (oldStates[i] != 2) continue;
            int slot = this.slotFor(oldKeys[i]);
            this.keys[slot] = oldKeys[i];
            this.values[slot] = oldValues[i];
            this.states[slot] = 2;
        }
        this.deleted = 0;
        this.lastSlot = -1;
    }

    private void allocateBuffers(int capacity) {
        this.keys = new char[capacity];
        this.values = new char[capacity];
        this.states = new byte[capacity];
        this.resizeThreshold = (int)((float)capacity * this.loadFactor);
    }

    @Override
    public char remove(char key) {
        int slot = this.slotFor(key);
        char value = this.values[slot];
        byte state = this.states[slot];
        if (state == 2) {
            ++this.deleted;
            --this.assigned;
            this.keys[slot] = '\u0000';
            this.values[slot] = '\u0000';
            this.states[slot] = 1;
        } else assert ('\u0000' == value) : "Default value expected.";
        return value;
    }

    @Override
    public final int removeAll(CharContainer container) {
        int before = this.deleted;
        for (CharCursor cursor : container) {
            this.remove(cursor.value);
        }
        return this.deleted - before;
    }

    @Override
    public final int removeAll(CharPredicate predicate) {
        int before = this.deleted;
        char[] keys = this.keys;
        char[] values = this.values;
        byte[] states = this.states;
        for (int i = 0; i < states.length; ++i) {
            if (states[i] != 2 || !predicate.apply(keys[i])) continue;
            ++this.deleted;
            --this.assigned;
            keys[i] = '\u0000';
            values[i] = '\u0000';
            states[i] = 1;
        }
        return this.deleted - before;
    }

    @Override
    public char get(char key) {
        return this.values[this.slotFor(key)];
    }

    public char lget() {
        assert (this.lastSlot >= 0) : "Call containsKey() first.";
        assert (this.states[this.lastSlot] == 2) : "Last call to exists did not have any associated value.";
        return this.values[this.lastSlot];
    }

    public char lset(char key) {
        assert (this.lastSlot >= 0) : "Call containsKey() first.";
        assert (this.states[this.lastSlot] == 2) : "Last call to exists did not have any associated value.";
        char previous = this.values[this.lastSlot];
        this.values[this.lastSlot] = key;
        return previous;
    }

    @Override
    public boolean containsKey(char key) {
        this.lastSlot = this.slotFor(key);
        int slot = this.lastSlot;
        return this.states[slot] == 2;
    }

    protected int roundCapacity(int requestedCapacity) {
        if (requestedCapacity > 0x40000000) {
            return 0x40000000;
        }
        return Math.max(4, BitUtil.nextHighestPowerOfTwo(requestedCapacity));
    }

    protected int nextCapacity(int current) {
        assert (current > 0 && Long.bitCount(current) == 1) : "Capacity must be a power of two.";
        assert (current << 1 > 0) : "Maximum capacity exceeded (1073741824).";
        if (current < 2) {
            current = 2;
        }
        return current << 1;
    }

    public int slotFor(char key) {
        int slots = this.states.length;
        int bucketMask = slots - 1;
        int slot = this.keyHashFunction.hash(key) & bucketMask;
        int i = 0;
        int deletedSlot = -1;
        byte state;
        while ((state = this.states[slot]) != 0) {
            if (state == 2 && this.keys[slot] == key) {
                return slot;
            }
            if (state == 1 && deletedSlot < 0) {
                deletedSlot = slot;
            }
            slot = slot + ++i & bucketMask;
        }
        return deletedSlot != -1 ? deletedSlot : slot;
    }

    @Override
    public void clear() {
        this.deleted = 0;
        this.assigned = 0;
        Arrays.fill(this.states, (byte)0);
    }

    @Override
    public int size() {
        return this.assigned;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int hashCode() {
        int h = 0;
        for (CharCharCursor c : this) {
            h += this.keyHashFunction.hash(c.key) + this.valueHashFunction.hash(c.value);
        }
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null) {
            CharCharMap other;
            if (obj == this) {
                return true;
            }
            if (obj instanceof CharCharMap && (other = (CharCharMap)obj).size() == this.size()) {
                for (CharCharCursor c : this) {
                    char v;
                    if (!other.containsKey(c.key) || c.value == (v = other.get(c.key))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public Iterator<CharCharCursor> iterator() {
        return new EntryIterator();
    }

    @Override
    public void forEach(CharCharProcedure procedure) {
        char[] keys = this.keys;
        char[] values = this.values;
        byte[] states = this.states;
        for (int i = 0; i < states.length; ++i) {
            if (states[i] != 2) continue;
            procedure.apply(keys[i], values[i]);
        }
    }

    @Override
    public KeySet keySet() {
        if (this.keySetView == null) {
            this.keySetView = new KeySet();
        }
        return this.keySetView;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        boolean first = true;
        for (CharCharCursor cursor : this) {
            if (!first) {
                buffer.append(", ");
            }
            buffer.append(cursor.key);
            buffer.append("=>");
            buffer.append(cursor.value);
            first = false;
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static CharCharOpenHashMap from(char[] keys, char[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        CharCharOpenHashMap map = new CharCharOpenHashMap();
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }

    public static CharCharOpenHashMap from(CharCharAssociativeContainer container) {
        return new CharCharOpenHashMap(container);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class KeySetIterator
    implements Iterator<CharCursor> {
        private static final int NOT_CACHED = -1;
        private static final int AT_END = -2;
        private final CharCursor cursor = new CharCursor();
        private int nextIndex = -1;

        public KeySetIterator() {
            this.cursor.index = -1;
        }

        @Override
        public boolean hasNext() {
            if (this.nextIndex == -1) {
                int i;
                for (i = this.cursor.index + 1; i < CharCharOpenHashMap.this.keys.length && CharCharOpenHashMap.this.states[i] != 2; ++i) {
                }
                this.nextIndex = i != CharCharOpenHashMap.this.keys.length ? i : -2;
            }
            return this.nextIndex != -2;
        }

        @Override
        public CharCursor next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.cursor.index = this.nextIndex;
            this.cursor.value = CharCharOpenHashMap.this.keys[this.nextIndex];
            this.nextIndex = -1;
            return this.cursor;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class KeySet
    extends AbstractCharCollection
    implements CharLookupContainer {
        private final CharCharOpenHashMap owner;

        public KeySet() {
            this.owner = CharCharOpenHashMap.this;
        }

        @Override
        public boolean contains(char e) {
            return CharCharOpenHashMap.this.containsKey(e);
        }

        @Override
        public void forEach(CharProcedure procedure) {
            char[] localKeys = this.owner.keys;
            byte[] localStates = this.owner.states;
            for (int i = 0; i < localStates.length; ++i) {
                if (localStates[i] != 2) continue;
                procedure.apply(localKeys[i]);
            }
        }

        @Override
        public void forEach(CharPredicate predicate) {
            char[] localKeys = this.owner.keys;
            byte[] localStates = this.owner.states;
            for (int i = 0; i < localStates.length && (localStates[i] != 2 || predicate.apply(localKeys[i])); ++i) {
            }
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<CharCursor> iterator() {
            return new KeySetIterator();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public int removeAll(CharPredicate predicate) {
            return this.owner.removeAll(predicate);
        }

        @Override
        public int removeAllOccurrences(char e) {
            boolean hasKey = this.owner.containsKey(e);
            int result = 0;
            if (hasKey) {
                this.owner.remove(e);
                result = 1;
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class EntryIterator
    implements Iterator<CharCharCursor> {
        private static final int NOT_CACHED = -1;
        private static final int AT_END = -2;
        private final CharCharCursor cursor = new CharCharCursor();
        private int nextIndex = -1;

        public EntryIterator() {
            this.cursor.index = -1;
        }

        @Override
        public boolean hasNext() {
            if (this.nextIndex == -1) {
                int i;
                for (i = this.cursor.index + 1; i < CharCharOpenHashMap.this.keys.length && CharCharOpenHashMap.this.states[i] != 2; ++i) {
                }
                this.nextIndex = i != CharCharOpenHashMap.this.keys.length ? i : -2;
            }
            return this.nextIndex != -2;
        }

        @Override
        public CharCharCursor next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.cursor.index = this.nextIndex;
            this.cursor.key = CharCharOpenHashMap.this.keys[this.nextIndex];
            this.cursor.value = CharCharOpenHashMap.this.values[this.nextIndex];
            this.nextIndex = -1;
            return this.cursor;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

