/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractFloatCollection;
import com.carrotsearch.hppc.FloatContainer;
import com.carrotsearch.hppc.FloatLookupContainer;
import com.carrotsearch.hppc.FloatSet;
import com.carrotsearch.hppc.cursors.FloatCursor;
import com.carrotsearch.hppc.hash.FloatHashFunction;
import com.carrotsearch.hppc.hash.FloatMurmurHash;
import com.carrotsearch.hppc.predicates.FloatPredicate;
import com.carrotsearch.hppc.procedures.FloatProcedure;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FloatOpenHashSet
extends AbstractFloatCollection
implements FloatLookupContainer,
FloatSet {
    public static final int DEFAULT_CAPACITY = 16;
    public static final int MIN_CAPACITY = 4;
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;
    public static final byte EMPTY = 0;
    public static final byte DELETED = 1;
    public static final byte ASSIGNED = 2;
    public float[] keys;
    public byte[] states;
    public int deleted;
    public int assigned;
    public final float loadFactor;
    private int resizeThreshold;
    private int lastSlot;
    public final FloatHashFunction hashFunction;

    public FloatOpenHashSet() {
        this(16, 0.75f);
    }

    public FloatOpenHashSet(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public FloatOpenHashSet(int initialCapacity, float loadFactor) {
        this(initialCapacity, loadFactor, new FloatMurmurHash());
    }

    public FloatOpenHashSet(FloatContainer container) {
        this((int)((float)container.size() * 1.75f));
        this.addAll(container);
    }

    public FloatOpenHashSet(int initialCapacity, float loadFactor, FloatHashFunction hashFunction) {
        initialCapacity = Math.max(4, initialCapacity);
        assert (initialCapacity > 0) : "Initial capacity must be between (0, 2147483647].";
        assert (loadFactor > 0.0f && loadFactor < 1.0f) : "Load factor must be between (0, 1).";
        assert (hashFunction != null) : "Hash function must not be null.";
        this.hashFunction = hashFunction;
        this.loadFactor = loadFactor;
        this.allocateBuffers(this.roundCapacity(initialCapacity));
    }

    @Override
    public boolean add(float e) {
        int slot;
        byte state;
        if (this.assigned + this.deleted >= this.resizeThreshold) {
            this.expandAndRehash();
        }
        if ((state = this.states[slot = this.slotFor(e)]) != 2) {
            ++this.assigned;
        }
        if (state == 1) {
            --this.deleted;
        }
        this.keys[slot] = e;
        this.states[slot] = 2;
        return state != 2;
    }

    public int add(float e1, float e2) {
        int count = 0;
        if (this.add(e1)) {
            ++count;
        }
        if (this.add(e2)) {
            ++count;
        }
        return count;
    }

    public int add(float ... elements) {
        int count = 0;
        for (float e : elements) {
            if (!this.add(e)) continue;
            ++count;
        }
        return count;
    }

    public final int addAll(FloatContainer container) {
        int count = 0;
        for (FloatCursor cursor : container) {
            if (!this.add(cursor.value)) continue;
            ++count;
        }
        return count;
    }

    private void expandAndRehash() {
        float[] oldKeys = this.keys;
        byte[] oldStates = this.states;
        if (this.assigned >= this.resizeThreshold) {
            this.allocateBuffers(this.nextCapacity(this.keys.length));
        } else {
            this.allocateBuffers(this.keys.length);
        }
        for (int i = 0; i < oldStates.length; ++i) {
            if (oldStates[i] != 2) continue;
            int slot = this.slotFor(oldKeys[i]);
            this.keys[slot] = oldKeys[i];
            this.states[slot] = 2;
        }
        this.deleted = 0;
        this.lastSlot = -1;
    }

    private void allocateBuffers(int capacity) {
        this.keys = new float[capacity];
        this.states = new byte[capacity];
        this.resizeThreshold = (int)((float)capacity * 0.75f);
    }

    @Override
    public int removeAllOccurrences(float key) {
        return this.remove(key) ? 1 : 0;
    }

    public boolean remove(float key) {
        int slot = this.slotFor(key);
        boolean hadEntry = false;
        if (this.states[slot] == 2) {
            ++this.deleted;
            --this.assigned;
            this.keys[slot] = 0.0f;
            this.states[slot] = 1;
            hadEntry = true;
        }
        return hadEntry;
    }

    public float lget() {
        assert (this.lastSlot >= 0) : "Call contains() first.";
        assert (this.states[this.lastSlot] == 2) : "Last call to exists did not have any associated value.";
        return this.keys[this.lastSlot];
    }

    @Override
    public boolean contains(float key) {
        this.lastSlot = this.slotFor(key);
        int slot = this.lastSlot;
        return this.states[slot] == 2;
    }

    protected int roundCapacity(int requestedCapacity) {
        int capacity;
        if (requestedCapacity > 0x40000000) {
            return 0x40000000;
        }
        for (capacity = 4; capacity < requestedCapacity; capacity <<= 1) {
        }
        return capacity;
    }

    protected int nextCapacity(int current) {
        assert (current > 0 && Long.bitCount(current) == 1) : "Capacity must be a power of two.";
        assert (current << 1 > 0) : "Maximum capacity exceeded (1073741824).";
        if (current < 2) {
            current = 2;
        }
        return current << 1;
    }

    public int slotFor(float key) {
        int slots = this.states.length;
        int bucketMask = slots - 1;
        int slot = this.hashFunction.hash(key) & bucketMask;
        int i = 0;
        int deletedSlot = -1;
        byte state;
        while ((state = this.states[slot]) != 0) {
            if (state == 2 && this.keys[slot] == key) {
                return slot;
            }
            if (state == 1 && deletedSlot < 0) {
                deletedSlot = slot;
            }
            slot = slot + ++i & bucketMask;
        }
        return deletedSlot != -1 ? deletedSlot : slot;
    }

    @Override
    public void clear() {
        this.deleted = 0;
        this.assigned = 0;
        Arrays.fill(this.states, (byte)0);
        Arrays.fill(this.keys, 0.0f);
    }

    @Override
    public int size() {
        return this.assigned;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int hashCode() {
        int h = 0;
        float[] keys = this.keys;
        byte[] states = this.states;
        int i = states.length;
        while (--i >= 0) {
            if (states[i] != 2) continue;
            h += this.hashFunction.hash(keys[i]);
        }
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null) {
            FloatSet other;
            if (obj == this) {
                return true;
            }
            if (obj instanceof FloatSet && (other = (FloatSet)obj).size() == this.size()) {
                for (FloatCursor c : this) {
                    if (other.contains(c.value)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public Iterator<FloatCursor> iterator() {
        return new EntryIterator();
    }

    @Override
    public void forEach(FloatProcedure procedure) {
        float[] keys = this.keys;
        byte[] states = this.states;
        for (int i = 0; i < states.length; ++i) {
            if (states[i] != 2) continue;
            procedure.apply(keys[i]);
        }
    }

    @Override
    public final float[] toArray() {
        float[] cloned = new float[this.assigned];
        int j = 0;
        for (int i = 0; i < this.keys.length; ++i) {
            if (this.states[i] != 2) continue;
            cloned[j++] = this.keys[i];
        }
        return cloned;
    }

    @Override
    public void forEach(FloatPredicate predicate) {
        float[] keys = this.keys;
        byte[] states = this.states;
        for (int i = 0; i < states.length && (states[i] != 2 || predicate.apply(keys[i])); ++i) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int removeAll(FloatPredicate predicate) {
        float[] keys = this.keys;
        byte[] states = this.states;
        int deleted = 0;
        try {
            for (int i = 0; i < states.length; ++i) {
                if (states[i] != 2 || !predicate.apply(keys[i])) continue;
                states[i] = 1;
                ++deleted;
            }
            int n = deleted;
            return n;
        }
        finally {
            this.assigned -= deleted;
            this.deleted += deleted;
        }
    }

    public static FloatOpenHashSet from(float ... elements) {
        FloatOpenHashSet set = new FloatOpenHashSet((int)((float)elements.length * 1.75f));
        set.add(elements);
        return set;
    }

    public static FloatOpenHashSet from(FloatContainer container) {
        return new FloatOpenHashSet(container);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class EntryIterator
    implements Iterator<FloatCursor> {
        private static final int NOT_CACHED = -1;
        private static final int AT_END = -2;
        private final FloatCursor cursor = new FloatCursor();
        private int nextIndex = -1;

        public EntryIterator() {
            this.cursor.index = -1;
        }

        @Override
        public boolean hasNext() {
            if (this.nextIndex == -1) {
                int i;
                for (i = this.cursor.index + 1; i < FloatOpenHashSet.this.keys.length && FloatOpenHashSet.this.states[i] != 2; ++i) {
                }
                this.nextIndex = i != FloatOpenHashSet.this.keys.length ? i : -2;
            }
            return this.nextIndex != -2;
        }

        @Override
        public FloatCursor next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.cursor.index = this.nextIndex;
            this.cursor.value = FloatOpenHashSet.this.keys[this.nextIndex];
            this.nextIndex = -1;
            return this.cursor;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

