/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bmi.dictionary.lucene;

import edu.mayo.bmi.dictionary.BaseDictionaryImpl;
import edu.mayo.bmi.dictionary.Dictionary;
import edu.mayo.bmi.dictionary.DictionaryException;
import edu.mayo.bmi.dictionary.lucene.LuceneDocumentMetaDataHitImpl;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import org.apache.log4j.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;

public class LuceneDictionaryImpl
extends BaseDictionaryImpl
implements Dictionary {
    private Searcher iv_searcher;
    private String iv_lookupFieldName;
    private int iv_maxHits;
    private Logger iv_logger = Logger.getLogger(this.getClass().getName());

    public LuceneDictionaryImpl(Searcher searcher, String lookupFieldName) {
        this(searcher, lookupFieldName, Integer.MAX_VALUE);
    }

    public LuceneDictionaryImpl(Searcher searcher, String lookupFieldName, int maxListHits) {
        this.iv_searcher = searcher;
        this.iv_lookupFieldName = lookupFieldName;
        this.iv_maxHits = maxListHits;
    }

    @Override
    public Collection getEntries(String str) throws DictionaryException {
        HashSet<LuceneDocumentMetaDataHitImpl> metaDataHitSet = new HashSet<LuceneDocumentMetaDataHitImpl>();
        try {
            TermQuery q = new TermQuery(new Term(this.iv_lookupFieldName, str));
            if (this.iv_maxHits == 0) {
                this.iv_maxHits = Integer.MAX_VALUE;
                this.iv_logger.warn("iv_maxHits was 0, using Integer.MAX_VALUE instead");
            }
            TopDocs topDoc = this.iv_searcher.search((Query)q, this.iv_maxHits);
            ScoreDoc[] hits = topDoc.scoreDocs;
            if (hits.length == this.iv_maxHits) {
                this.iv_logger.warn("'iv_maxHits' equals the list length returned by the lucene query (" + hits.length + ").");
                this.iv_logger.warn("You may want to consider setting a higher value, since there may be more entries not being returned in the event greater than " + this.iv_maxHits + " exist.");
            }
            int i = 0;
            while (i < hits.length) {
                int docId = hits[i].doc;
                Document luceneDoc = this.iv_searcher.doc(docId);
                LuceneDocumentMetaDataHitImpl mdh = new LuceneDocumentMetaDataHitImpl(luceneDoc);
                metaDataHitSet.add(mdh);
                ++i;
            }
            return metaDataHitSet;
        }
        catch (IOException ioe) {
            throw new DictionaryException(ioe);
        }
    }

    @Override
    public boolean contains(String str) throws DictionaryException {
        try {
            TermQuery q = new TermQuery(new Term(this.iv_lookupFieldName, str));
            TopDocs topDoc = this.iv_searcher.search((Query)q, this.iv_maxHits);
            ScoreDoc[] hits = topDoc.scoreDocs;
            return hits != null && hits.length > 0;
        }
        catch (IOException ioe) {
            throw new DictionaryException(ioe);
        }
    }
}

