/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bmi.fsm.drugner.machines.elements;

import edu.mayo.bmi.fsm.condition.IntegerValueCondition;
import edu.mayo.bmi.fsm.condition.NumberCondition;
import edu.mayo.bmi.fsm.condition.PunctuationValueCondition;
import edu.mayo.bmi.fsm.drugner.output.util.DecimalStrengthToken;
import edu.mayo.bmi.fsm.state.NamedState;
import edu.mayo.bmi.fsm.token.BaseToken;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.openai.util.fsm.AnyCondition;
import net.openai.util.fsm.Machine;
import net.openai.util.fsm.State;

public class DecimalStrengthFSM {
    Set iv_fullTextSet = new HashSet();
    Set iv_shortTextSet = new HashSet();
    private Set iv_machineSet = new HashSet();

    public DecimalStrengthFSM() {
        this.iv_machineSet.add(this.getDecimalStrengthMachine());
    }

    private Machine getDecimalStrengthMachine() {
        NamedState startState = new NamedState("START");
        NamedState endState = new NamedState("END");
        endState.setEndStateFlag(true);
        Machine m = new Machine(startState);
        NamedState zeroNumState = new NamedState("ZERO_NUM");
        NamedState fractionTextState = new NamedState("NUMERATOR_TEXT");
        NamedState dashState = new NamedState("DASH");
        startState.addTransition(new IntegerValueCondition(0), zeroNumState);
        startState.addTransition(new AnyCondition(), startState);
        zeroNumState.addTransition(new PunctuationValueCondition('.'), fractionTextState);
        zeroNumState.addTransition(new AnyCondition(), startState);
        fractionTextState.addTransition(new NumberCondition(), dashState);
        fractionTextState.addTransition(new AnyCondition(), startState);
        dashState.addTransition(new PunctuationValueCondition('-'), endState);
        dashState.addTransition(new AnyCondition(), startState);
        endState.addTransition(new AnyCondition(), startState);
        return m;
    }

    public Set execute(List tokens) throws Exception {
        HashSet<DecimalStrengthToken> fractionSet = new HashSet<DecimalStrengthToken>();
        HashMap<Machine, Integer> tokenStartMap = new HashMap<Machine, Integer>();
        int i = 0;
        while (i < tokens.size()) {
            BaseToken token = (BaseToken)tokens.get(i);
            for (Machine fsm : this.iv_machineSet) {
                int tokenStartIndex;
                fsm.input(token);
                State currentState = fsm.getCurrentState();
                if (currentState.getStartStateFlag()) {
                    tokenStartMap.put(fsm, new Integer(i));
                }
                if (!currentState.getEndStateFlag()) continue;
                Object o = tokenStartMap.get(fsm);
                if (o == null) {
                    tokenStartIndex = 0;
                } else {
                    tokenStartIndex = (Integer)o;
                    ++tokenStartIndex;
                }
                BaseToken startToken = (BaseToken)tokens.get(tokenStartIndex);
                BaseToken endToken = token;
                DecimalStrengthToken fractionToken = new DecimalStrengthToken(startToken.getStartOffset(), endToken.getEndOffset());
                fractionSet.add(fractionToken);
                fsm.reset();
            }
            ++i;
        }
        tokenStartMap.clear();
        for (Machine fsm : this.iv_machineSet) {
            fsm.reset();
        }
        return fractionSet;
    }
}

