/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bmi.fsm.drugner.machines.elements;

import edu.mayo.bmi.fsm.condition.DisjoinCondition;
import edu.mayo.bmi.fsm.condition.PunctuationValueCondition;
import edu.mayo.bmi.fsm.condition.RangeCondition;
import edu.mayo.bmi.fsm.condition.TextValueCondition;
import edu.mayo.bmi.fsm.condition.WordSetCondition;
import edu.mayo.bmi.fsm.drugner.elements.conditions.RangeStrengthCondition;
import edu.mayo.bmi.fsm.drugner.output.elements.RouteToken;
import edu.mayo.bmi.fsm.state.NamedState;
import edu.mayo.bmi.fsm.token.BaseToken;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.openai.util.fsm.AnyCondition;
import net.openai.util.fsm.Machine;
import net.openai.util.fsm.State;

public class RouteFSM {
    Set iv_middleTermSet = new HashSet();
    Set iv_periodSet = new HashSet();
    Set iv_singleTopicalWordSet = new HashSet();
    Set iv_specifiedGastricWordSet = new HashSet();
    Set iv_singleOralWordSet = new HashSet();
    Set iv_singleInjectWordSet = new HashSet();
    Set iv_singleRectalWordSet = new HashSet();
    Set iv_specifiedInjectWordSet = new HashSet();
    Set iv_specifiedOralWordSet = new HashSet();
    Set iv_specifiedPatchesWordSet = new HashSet();
    private Set iv_machineSet = new HashSet();
    private Machine iv_PatchesMachine;
    private Machine iv_GastricMachine;
    private Machine iv_TopicalMachine;
    private Machine iv_OralMachine;
    private Machine iv_RectalMachine;
    private Machine iv_InjectMachine;

    public RouteFSM() {
        this.iv_specifiedOralWordSet.add("nebulizer");
        this.iv_specifiedOralWordSet.add("nebulizers");
        this.iv_specifiedOralWordSet.add("neb");
        this.iv_specifiedInjectWordSet.add("injection");
        this.iv_specifiedInjectWordSet.add("injections");
        this.iv_specifiedInjectWordSet.add("injected");
        this.iv_specifiedPatchesWordSet.add("transdermal");
        this.iv_specifiedGastricWordSet.add("gastric");
        this.iv_specifiedGastricWordSet.add("duodental");
        this.iv_singleTopicalWordSet.add("drop");
        this.iv_singleTopicalWordSet.add("drops");
        this.iv_singleTopicalWordSet.add("skin");
        this.iv_singleTopicalWordSet.add("cream");
        this.iv_singleTopicalWordSet.add("creams");
        this.iv_singleTopicalWordSet.add("pv");
        this.iv_singleTopicalWordSet.add("topically");
        this.iv_singleTopicalWordSet.add("topical");
        this.iv_singleTopicalWordSet.add("vaginally");
        this.iv_singleOralWordSet.add("po");
        this.iv_singleOralWordSet.add("mouth");
        this.iv_singleOralWordSet.add("orally");
        this.iv_singleOralWordSet.add("oral");
        this.iv_singleRectalWordSet.add("rectally");
        this.iv_singleRectalWordSet.add("anally");
        this.iv_singleRectalWordSet.add("pr");
        this.iv_singleInjectWordSet.add("subcutaneously");
        this.iv_singleInjectWordSet.add("subcutaneously");
        this.iv_singleInjectWordSet.add("intervenous");
        this.iv_singleInjectWordSet.add("intervenously");
        this.iv_singleInjectWordSet.add("injection");
        this.iv_singleInjectWordSet.add("injections");
        this.iv_singleInjectWordSet.add("injected");
        this.iv_middleTermSet.add("a");
        this.iv_middleTermSet.add("an");
        this.iv_middleTermSet.add("as");
        this.iv_middleTermSet.add("by");
        this.iv_middleTermSet.add("the");
        this.iv_middleTermSet.add("via");
        this.iv_middleTermSet.add("tube");
        this.iv_middleTermSet.add("in");
        this.iv_PatchesMachine = this.getPatchesMachine();
        this.iv_GastricMachine = this.getGastricMachine();
        this.iv_TopicalMachine = this.getTopicalMachine();
        this.iv_OralMachine = this.getOralMachine();
        this.iv_RectalMachine = this.getRectalMachine();
        this.iv_InjectMachine = this.getInjectionMachine();
        this.iv_machineSet.add(this.iv_PatchesMachine);
        this.iv_machineSet.add(this.iv_GastricMachine);
        this.iv_machineSet.add(this.iv_TopicalMachine);
        this.iv_machineSet.add(this.iv_OralMachine);
        this.iv_machineSet.add(this.iv_RectalMachine);
        this.iv_machineSet.add(this.iv_InjectMachine);
    }

    private Machine getPatchesMachine() {
        NamedState startState = new NamedState("START");
        NamedState endState = new NamedState("END");
        endState.setEndStateFlag(true);
        Machine m = new Machine(startState);
        NamedState leftAbbreviateState = new NamedState("LEFT_FREQ");
        NamedState leftDosagesState = new NamedState("LEFT_DOSE");
        NamedState lastTextState = new NamedState("RIGHT_FREQ");
        NamedState middleATextState = new NamedState("MID_TEXT");
        NamedState firstDashState = new NamedState("FIRSTDASH");
        NamedState secondDashState = new NamedState("SECONDDASH");
        PunctuationValueCondition firstDashCondition = new PunctuationValueCondition('-');
        PunctuationValueCondition secondDashCondition = new PunctuationValueCondition('-');
        DisjoinCondition rangeCombineCondition = new DisjoinCondition(new RangeCondition(), new RangeStrengthCondition());
        WordSetCondition initialMiddleTextCondition = new WordSetCondition(this.iv_middleTermSet, true);
        WordSetCondition firstMiddleTextCondition = new WordSetCondition(this.iv_middleTermSet, true);
        WordSetCondition secondMiddleTextCondition = new WordSetCondition(this.iv_middleTermSet, true);
        WordSetCondition thirdMiddleTextCondition = new WordSetCondition(this.iv_middleTermSet, true);
        WordSetCondition fourthMiddleTextCondition = new WordSetCondition(this.iv_middleTermSet, true);
        WordSetCondition specificWordCondition = new WordSetCondition(this.iv_specifiedPatchesWordSet, false);
        startState.addTransition(new TextValueCondition("a", true), leftAbbreviateState);
        startState.addTransition(initialMiddleTextCondition, leftAbbreviateState);
        startState.addTransition(rangeCombineCondition, leftDosagesState);
        startState.addTransition(specificWordCondition, endState);
        startState.addTransition(new AnyCondition(), startState);
        leftAbbreviateState.addTransition(firstMiddleTextCondition, middleATextState);
        leftAbbreviateState.addTransition(firstDashCondition, firstDashState);
        leftAbbreviateState.addTransition(new AnyCondition(), startState);
        firstDashState.addTransition(thirdMiddleTextCondition, middleATextState);
        firstDashState.addTransition(new AnyCondition(), startState);
        middleATextState.addTransition(secondMiddleTextCondition, lastTextState);
        middleATextState.addTransition(secondDashCondition, secondDashState);
        middleATextState.addTransition(new AnyCondition(), startState);
        secondDashState.addTransition(fourthMiddleTextCondition, lastTextState);
        secondDashState.addTransition(new AnyCondition(), startState);
        lastTextState.addTransition(new AnyCondition(), startState);
        endState.addTransition(new AnyCondition(), startState);
        return m;
    }

    private Machine getGastricMachine() {
        NamedState startState = new NamedState("START");
        NamedState endState = new NamedState("END");
        endState.setEndStateFlag(true);
        Machine m = new Machine(startState);
        NamedState leftAbbreviateState = new NamedState("LEFT_FREQ");
        NamedState leftDosagesState = new NamedState("LEFT_DOSE");
        NamedState lastTextState = new NamedState("RIGHT_FREQ");
        NamedState middleATextState = new NamedState("MID_TEXT");
        NamedState firstDashState = new NamedState("FIRSTDASH");
        NamedState secondDashState = new NamedState("SECONDDASH");
        PunctuationValueCondition firstDashCondition = new PunctuationValueCondition('-');
        PunctuationValueCondition secondDashCondition = new PunctuationValueCondition('-');
        DisjoinCondition rangeCombineCondition = new DisjoinCondition(new RangeCondition(), new RangeStrengthCondition());
        WordSetCondition initialMiddleTextCondition = new WordSetCondition(this.iv_middleTermSet, true);
        WordSetCondition firstMiddleTextCondition = new WordSetCondition(this.iv_middleTermSet, true);
        WordSetCondition secondMiddleTextCondition = new WordSetCondition(this.iv_middleTermSet, true);
        WordSetCondition thirdMiddleTextCondition = new WordSetCondition(this.iv_middleTermSet, true);
        WordSetCondition fourthMiddleTextCondition = new WordSetCondition(this.iv_middleTermSet, true);
        WordSetCondition specificWordCondition = new WordSetCondition(this.iv_specifiedGastricWordSet, false);
        startState.addTransition(new TextValueCondition("a", true), leftAbbreviateState);
        startState.addTransition(initialMiddleTextCondition, leftAbbreviateState);
        startState.addTransition(rangeCombineCondition, leftDosagesState);
        startState.addTransition(specificWordCondition, endState);
        startState.addTransition(new AnyCondition(), startState);
        leftAbbreviateState.addTransition(firstMiddleTextCondition, middleATextState);
        leftAbbreviateState.addTransition(firstDashCondition, firstDashState);
        leftAbbreviateState.addTransition(new AnyCondition(), startState);
        firstDashState.addTransition(thirdMiddleTextCondition, middleATextState);
        firstDashState.addTransition(new AnyCondition(), startState);
        middleATextState.addTransition(secondMiddleTextCondition, lastTextState);
        middleATextState.addTransition(secondDashCondition, secondDashState);
        middleATextState.addTransition(new AnyCondition(), startState);
        secondDashState.addTransition(fourthMiddleTextCondition, lastTextState);
        secondDashState.addTransition(new AnyCondition(), startState);
        lastTextState.addTransition(new AnyCondition(), startState);
        endState.addTransition(new AnyCondition(), startState);
        return m;
    }

    private Machine getTopicalMachine() {
        NamedState startState = new NamedState("START");
        NamedState endState = new NamedState("END");
        endState.setEndStateFlag(true);
        Machine m = new Machine(startState);
        NamedState leftAbbreviateState = new NamedState("LEFT_FREQ");
        NamedState leftDosagesState = new NamedState("LEFT_DOSE");
        NamedState lastTextState = new NamedState("RIGHT_FREQ");
        NamedState middleATextState = new NamedState("MID_TEXT");
        NamedState firstDashState = new NamedState("FIRSTDASH");
        NamedState secondDashState = new NamedState("SECONDDASH");
        NamedState leftAbbreviatePState = new NamedState("LEFT_P");
        NamedState rightAbbreviatePVState = new NamedState("RIGHT_PV");
        NamedState firstDotPState = new NamedState("FIRSTDOTP");
        PunctuationValueCondition firstDashCondition = new PunctuationValueCondition('-');
        PunctuationValueCondition secondDashCondition = new PunctuationValueCondition('-');
        DisjoinCondition rangeCombineCondition = new DisjoinCondition(new RangeCondition(), new RangeStrengthCondition());
        WordSetCondition initialMiddleTextCondition = new WordSetCondition(this.iv_middleTermSet, true);
        WordSetCondition firstMiddleTextCondition = new WordSetCondition(this.iv_middleTermSet, true);
        WordSetCondition secondMiddleTextCondition = new WordSetCondition(this.iv_middleTermSet, true);
        WordSetCondition thirdMiddleTextCondition = new WordSetCondition(this.iv_middleTermSet, true);
        WordSetCondition fourthMiddleTextCondition = new WordSetCondition(this.iv_middleTermSet, true);
        WordSetCondition soloCondition = new WordSetCondition(this.iv_singleTopicalWordSet, true);
        startState.addTransition(new TextValueCondition("a", true), leftAbbreviateState);
        startState.addTransition(new TextValueCondition("p", true), leftAbbreviatePState);
        startState.addTransition(initialMiddleTextCondition, leftAbbreviateState);
        startState.addTransition(rangeCombineCondition, leftDosagesState);
        startState.addTransition(soloCondition, endState);
        startState.addTransition(new AnyCondition(), startState);
        leftAbbreviatePState.addTransition(new PunctuationValueCondition('.'), firstDotPState);
        leftAbbreviatePState.addTransition(new AnyCondition(), startState);
        firstDotPState.addTransition(soloCondition, endState);
        firstDotPState.addTransition(new TextValueCondition("v", true), rightAbbreviatePVState);
        firstDotPState.addTransition(new AnyCondition(), startState);
        leftAbbreviateState.addTransition(firstMiddleTextCondition, middleATextState);
        leftAbbreviateState.addTransition(firstDashCondition, firstDashState);
        leftAbbreviateState.addTransition(soloCondition, endState);
        leftAbbreviateState.addTransition(new AnyCondition(), startState);
        firstDashState.addTransition(thirdMiddleTextCondition, middleATextState);
        firstDashState.addTransition(new AnyCondition(), startState);
        middleATextState.addTransition(secondMiddleTextCondition, lastTextState);
        middleATextState.addTransition(secondDashCondition, secondDashState);
        middleATextState.addTransition(new AnyCondition(), startState);
        secondDashState.addTransition(fourthMiddleTextCondition, lastTextState);
        secondDashState.addTransition(new AnyCondition(), startState);
        lastTextState.addTransition(new AnyCondition(), startState);
        rightAbbreviatePVState.addTransition(new PunctuationValueCondition('.'), endState);
        rightAbbreviatePVState.addTransition(new AnyCondition(), startState);
        endState.addTransition(new AnyCondition(), startState);
        return m;
    }

    private Machine getOralMachine() {
        NamedState startState = new NamedState("START");
        NamedState endState = new NamedState("END");
        endState.setEndStateFlag(true);
        Machine m = new Machine(startState);
        NamedState leftAbbreviateState = new NamedState("LEFT_FREQ");
        NamedState leftDosagesState = new NamedState("LEFT_DOSE");
        NamedState lastTextState = new NamedState("RIGHT_FREQ");
        NamedState middleATextState = new NamedState("MID_TEXT");
        NamedState firstDashState = new NamedState("FIRSTDASH");
        NamedState secondDashState = new NamedState("SECONDDASH");
        NamedState leftAbbreviatePState = new NamedState("LEFT_P");
        NamedState rightAbbreviatePOState = new NamedState("RIGHT_PO");
        NamedState firstDotPState = new NamedState("FIRSTDOTP");
        PunctuationValueCondition firstPODotCondition = new PunctuationValueCondition('.');
        PunctuationValueCondition secondPODotCondition = new PunctuationValueCondition('.');
        PunctuationValueCondition firstDashCondition = new PunctuationValueCondition('-');
        PunctuationValueCondition secondDashCondition = new PunctuationValueCondition('-');
        DisjoinCondition rangeCombineCondition = new DisjoinCondition(new RangeCondition(), new RangeStrengthCondition());
        WordSetCondition initialMiddleTextCondition = new WordSetCondition(this.iv_middleTermSet, true);
        WordSetCondition firstMiddleTextCondition = new WordSetCondition(this.iv_middleTermSet, true);
        WordSetCondition secondMiddleTextCondition = new WordSetCondition(this.iv_middleTermSet, true);
        WordSetCondition thirdMiddleTextCondition = new WordSetCondition(this.iv_middleTermSet, true);
        WordSetCondition fourthMiddleTextCondition = new WordSetCondition(this.iv_middleTermSet, true);
        WordSetCondition soloCondition = new WordSetCondition(this.iv_singleOralWordSet, true);
        WordSetCondition specificWordCondition = new WordSetCondition(this.iv_specifiedOralWordSet, false);
        startState.addTransition(new TextValueCondition("a", true), leftAbbreviateState);
        startState.addTransition(new TextValueCondition("p", true), leftAbbreviatePState);
        startState.addTransition(initialMiddleTextCondition, leftAbbreviateState);
        startState.addTransition(rangeCombineCondition, leftDosagesState);
        startState.addTransition(soloCondition, endState);
        startState.addTransition(specificWordCondition, endState);
        startState.addTransition(new AnyCondition(), startState);
        leftAbbreviatePState.addTransition(firstPODotCondition, firstDotPState);
        leftAbbreviatePState.addTransition(new AnyCondition(), startState);
        firstDotPState.addTransition(soloCondition, endState);
        firstDotPState.addTransition(new TextValueCondition("o", true), rightAbbreviatePOState);
        firstDotPState.addTransition(new AnyCondition(), startState);
        leftAbbreviateState.addTransition(firstMiddleTextCondition, middleATextState);
        leftAbbreviateState.addTransition(firstDashCondition, firstDashState);
        leftAbbreviateState.addTransition(soloCondition, endState);
        leftAbbreviateState.addTransition(new AnyCondition(), startState);
        firstDashState.addTransition(thirdMiddleTextCondition, middleATextState);
        firstDashState.addTransition(new AnyCondition(), startState);
        middleATextState.addTransition(secondMiddleTextCondition, lastTextState);
        middleATextState.addTransition(secondDashCondition, secondDashState);
        middleATextState.addTransition(new AnyCondition(), startState);
        secondDashState.addTransition(fourthMiddleTextCondition, lastTextState);
        secondDashState.addTransition(new AnyCondition(), startState);
        lastTextState.addTransition(new AnyCondition(), startState);
        rightAbbreviatePOState.addTransition(secondPODotCondition, endState);
        rightAbbreviatePOState.addTransition(new AnyCondition(), startState);
        endState.addTransition(new AnyCondition(), startState);
        return m;
    }

    private Machine getRectalMachine() {
        NamedState startState = new NamedState("START");
        NamedState endState = new NamedState("END");
        endState.setEndStateFlag(true);
        Machine m = new Machine(startState);
        WordSetCondition soloCondition = new WordSetCondition(this.iv_singleRectalWordSet, true);
        startState.addTransition(soloCondition, endState);
        startState.addTransition(new AnyCondition(), startState);
        endState.addTransition(new AnyCondition(), startState);
        return m;
    }

    private Machine getInjectionMachine() {
        NamedState startState = new NamedState("START");
        NamedState endState = new NamedState("END");
        endState.setEndStateFlag(true);
        Machine m = new Machine(startState);
        WordSetCondition soloCondition = new WordSetCondition(this.iv_singleInjectWordSet, true);
        startState.addTransition(soloCondition, endState);
        startState.addTransition(new AnyCondition(), startState);
        endState.addTransition(new AnyCondition(), startState);
        return m;
    }

    public Set execute(List tokens, Set overrideSet) throws Exception {
        HashSet<RouteToken> rangeSet = new HashSet<RouteToken>();
        HashMap<Machine, Integer> tokenStartMap = new HashMap<Machine, Integer>();
        Iterator overrideTokenItr = overrideSet.iterator();
        HashMap<Integer, BaseToken> overrideTokenMap = new HashMap<Integer, BaseToken>();
        while (overrideTokenItr.hasNext()) {
            BaseToken t = (BaseToken)overrideTokenItr.next();
            Integer key = new Integer(t.getStartOffset());
            overrideTokenMap.put(key, t);
        }
        boolean overrideOn = false;
        int overrideEndOffset = -1;
        int i = 0;
        while (i < tokens.size()) {
            block20: {
                BaseToken token;
                block21: {
                    Integer key;
                    block19: {
                        token = (BaseToken)tokens.get(i);
                        key = new Integer(token.getStartOffset());
                        if (!overrideOn) break block19;
                        if (token.getStartOffset() < overrideEndOffset) break block20;
                        overrideOn = false;
                        overrideEndOffset = -1;
                        break block21;
                    }
                    if (overrideTokenMap.containsKey(key)) {
                        token = (BaseToken)overrideTokenMap.get(key);
                        overrideOn = true;
                        overrideEndOffset = token.getEndOffset();
                    }
                }
                for (Machine fsm : this.iv_machineSet) {
                    int tokenStartIndex;
                    fsm.input(token);
                    State currentState = fsm.getCurrentState();
                    if (currentState.getStartStateFlag()) {
                        tokenStartMap.put(fsm, new Integer(i));
                    }
                    if (!currentState.getEndStateFlag()) continue;
                    Object o = tokenStartMap.get(fsm);
                    if (o == null) {
                        tokenStartIndex = 0;
                    } else {
                        tokenStartIndex = (Integer)o;
                        ++tokenStartIndex;
                    }
                    BaseToken startToken = (BaseToken)tokens.get(tokenStartIndex);
                    BaseToken endToken = token;
                    RouteToken segmentToken = null;
                    if (fsm.equals(this.iv_PatchesMachine)) {
                        segmentToken = new RouteToken(startToken.getStartOffset(), endToken.getEndOffset());
                        segmentToken.setFormMethod(11);
                    } else if (fsm.equals(this.iv_GastricMachine)) {
                        segmentToken = new RouteToken(startToken.getStartOffset(), endToken.getEndOffset());
                        segmentToken.setFormMethod(2);
                    } else if (fsm.equals(this.iv_TopicalMachine)) {
                        segmentToken = new RouteToken(startToken.getStartOffset(), endToken.getEndOffset());
                        segmentToken.setFormMethod(0);
                    } else if (fsm.equals(this.iv_OralMachine)) {
                        segmentToken = new RouteToken(startToken.getStartOffset(), endToken.getEndOffset());
                        segmentToken.setFormMethod(1);
                    } else if (fsm.equals(this.iv_RectalMachine)) {
                        segmentToken = new RouteToken(startToken.getStartOffset(), endToken.getEndOffset());
                        segmentToken.setFormMethod(3);
                    } else if (fsm.equals(this.iv_InjectMachine)) {
                        segmentToken = new RouteToken(startToken.getStartOffset(), endToken.getEndOffset());
                        segmentToken.setFormMethod(4);
                    }
                    rangeSet.add(segmentToken);
                    fsm.reset();
                }
            }
            ++i;
        }
        tokenStartMap.clear();
        for (Machine fsm : this.iv_machineSet) {
            fsm.reset();
        }
        return rangeSet;
    }

    public Set execute(List tokens) throws Exception {
        HashSet<RouteToken> fractionSet = new HashSet<RouteToken>();
        HashMap<Machine, Integer> tokenStartMap = new HashMap<Machine, Integer>();
        int i = 0;
        while (i < tokens.size()) {
            BaseToken token = (BaseToken)tokens.get(i);
            for (Machine fsm : this.iv_machineSet) {
                int tokenStartIndex;
                fsm.input(token);
                State currentState = fsm.getCurrentState();
                if (currentState.getStartStateFlag()) {
                    tokenStartMap.put(fsm, new Integer(i));
                }
                if (!currentState.getEndStateFlag()) continue;
                Object o = tokenStartMap.get(fsm);
                if (o == null) {
                    tokenStartIndex = 0;
                } else {
                    tokenStartIndex = (Integer)o;
                    ++tokenStartIndex;
                }
                BaseToken startToken = (BaseToken)tokens.get(tokenStartIndex);
                BaseToken endToken = token;
                RouteToken segmentToken = null;
                if (fsm.equals(this.iv_PatchesMachine)) {
                    segmentToken = new RouteToken(startToken.getStartOffset(), endToken.getEndOffset());
                    segmentToken.setFormMethod(11);
                } else if (fsm.equals(this.iv_GastricMachine)) {
                    segmentToken = new RouteToken(startToken.getStartOffset(), endToken.getEndOffset());
                    segmentToken.setFormMethod(2);
                } else if (fsm.equals(this.iv_TopicalMachine)) {
                    segmentToken = new RouteToken(startToken.getStartOffset(), endToken.getEndOffset());
                    segmentToken.setFormMethod(0);
                } else if (fsm.equals(this.iv_OralMachine)) {
                    segmentToken = new RouteToken(startToken.getStartOffset(), endToken.getEndOffset());
                    segmentToken.setFormMethod(1);
                } else if (fsm.equals(this.iv_RectalMachine)) {
                    segmentToken = new RouteToken(startToken.getStartOffset(), endToken.getEndOffset());
                    segmentToken.setFormMethod(3);
                } else if (fsm.equals(this.iv_InjectMachine)) {
                    segmentToken = new RouteToken(startToken.getStartOffset(), endToken.getEndOffset());
                    segmentToken.setFormMethod(4);
                }
                fractionSet.add(segmentToken);
                fsm.reset();
            }
            ++i;
        }
        tokenStartMap.clear();
        for (Machine fsm : this.iv_machineSet) {
            fsm.reset();
        }
        return fractionSet;
    }
}

