/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bmi.fsm.drugner.machines.util;

import edu.mayo.bmi.fsm.condition.TextSetCondition;
import edu.mayo.bmi.fsm.drugner.output.util.NonIndicator;
import edu.mayo.bmi.fsm.state.NamedState;
import edu.mayo.bmi.fsm.state.NonTerminalEndState;
import edu.mayo.bmi.fsm.token.BaseToken;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.openai.util.fsm.AnyCondition;
import net.openai.util.fsm.Machine;
import net.openai.util.fsm.State;

public class NonIndicatorFSM {
    private Set iv_negDeterminersSet = new HashSet();
    private Set iv_machineSet = new HashSet();
    private Set iv_negInitialDeterminersSet = new HashSet();
    private Machine iv_negInitialDetermineMachine = new Machine();

    public NonIndicatorFSM() {
        this.iv_negDeterminersSet.add("non");
        this.iv_negInitialDeterminersSet.add("No");
        this.iv_negInitialDetermineMachine = this.getInitialNegIndicatorMachine();
        this.iv_machineSet.add(this.getAdjNegIndicatorMachine());
        this.iv_machineSet.add(this.iv_negInitialDetermineMachine);
    }

    private Machine getInitialNegIndicatorMachine() {
        NamedState startState = new NamedState("START");
        NamedState endState = new NamedState("END");
        NonTerminalEndState ntEndState = new NonTerminalEndState("NON TERMINAL END");
        endState.setEndStateFlag(true);
        ntEndState.setEndStateFlag(true);
        Machine m = new Machine(startState);
        NamedState negDetState = new NamedState("NEG_DET");
        TextSetCondition negInitDetC = new TextSetCondition(this.iv_negInitialDeterminersSet, true);
        startState.addTransition(negInitDetC, negDetState);
        startState.addTransition(new AnyCondition(), startState);
        negDetState.addTransition(new AnyCondition(), startState);
        endState.addTransition(new AnyCondition(), startState);
        return m;
    }

    private Machine getAdjNegIndicatorMachine() {
        NamedState startState = new NamedState("START");
        NamedState endState = new NamedState("END");
        endState.setEndStateFlag(true);
        Machine m = new Machine(startState);
        NamedState negAdjState = new NamedState("NEG_ADJ");
        TextSetCondition negDetC = new TextSetCondition(this.iv_negDeterminersSet, false);
        startState.addTransition(negDetC, negAdjState);
        startState.addTransition(new AnyCondition(), startState);
        negAdjState.addTransition(new AnyCondition(), startState);
        return m;
    }

    public Set execute(List tokens) throws Exception {
        HashSet<NonIndicator> outSet = new HashSet<NonIndicator>();
        HashMap<Machine, Integer> tokenStartMap = new HashMap<Machine, Integer>();
        int i = 0;
        while (i < tokens.size()) {
            BaseToken token = (BaseToken)tokens.get(i);
            for (Machine fsm : this.iv_machineSet) {
                int tokenStartIndex;
                fsm.input(token);
                State currentState = fsm.getCurrentState();
                if (currentState.getStartStateFlag()) {
                    tokenStartMap.put(fsm, new Integer(i));
                }
                if (!currentState.getEndStateFlag()) continue;
                Object o = tokenStartMap.get(fsm);
                if (o == null) {
                    tokenStartIndex = 0;
                } else {
                    tokenStartIndex = (Integer)o;
                    ++tokenStartIndex;
                }
                BaseToken endToken = null;
                endToken = currentState instanceof NonTerminalEndState ? (BaseToken)tokens.get(i - 1) : token;
                BaseToken startToken = (BaseToken)tokens.get(tokenStartIndex);
                NonIndicator neg = null;
                neg = fsm.equals(this.iv_negInitialDetermineMachine) ? new NonIndicator(startToken.getStartOffset(), endToken.getEndOffset()) : new NonIndicator(startToken.getStartOffset(), endToken.getEndOffset());
                outSet.add(neg);
                fsm.reset();
            }
            ++i;
        }
        tokenStartMap.clear();
        for (Machine fsm : this.iv_machineSet) {
            fsm.reset();
        }
        return outSet;
    }
}

