/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bmi.fsm.drugner.machines.util;

import edu.mayo.bmi.fsm.condition.IntegerCondition;
import edu.mayo.bmi.fsm.condition.PunctuationValueCondition;
import edu.mayo.bmi.fsm.condition.WordSetCondition;
import edu.mayo.bmi.fsm.drugner.elements.conditions.StrengthCondition;
import edu.mayo.bmi.fsm.drugner.output.util.SuffixStrengthToken;
import edu.mayo.bmi.fsm.state.NamedState;
import edu.mayo.bmi.fsm.token.BaseToken;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.openai.util.fsm.AnyCondition;
import net.openai.util.fsm.Machine;
import net.openai.util.fsm.State;

public class SuffixStrengthFSM {
    Set iv_textSuffixSet = new HashSet();
    private Set iv_machineSet = new HashSet();

    public SuffixStrengthFSM() {
        this.iv_textSuffixSet.add("gtts");
        this.iv_textSuffixSet.add("ui");
        this.iv_textSuffixSet.add("iu");
        this.iv_textSuffixSet.add("meq");
        this.iv_textSuffixSet.add("mcg");
        this.iv_textSuffixSet.add("gr");
        this.iv_textSuffixSet.add("tsp");
        this.iv_textSuffixSet.add("tbsp");
        this.iv_textSuffixSet.add("g");
        this.iv_textSuffixSet.add("mg");
        this.iv_textSuffixSet.add("dl");
        this.iv_textSuffixSet.add("cl");
        this.iv_textSuffixSet.add("ml");
        this.iv_textSuffixSet.add("kg");
        this.iv_textSuffixSet.add("cc");
        this.iv_textSuffixSet.add("ou");
        this.iv_machineSet.add(this.getDashMachine());
    }

    private Machine getDashMachine() {
        NamedState startState = new NamedState("START");
        NamedState endState = new NamedState("END");
        endState.setEndStateFlag(true);
        Machine m = new Machine(startState);
        NamedState leftNumTextState = new NamedState("LEFT_DOSAGE");
        NamedState rightNumTextState = new NamedState("RIGHT_DOSAGE");
        NamedState fslashState = new NamedState("FSLASH");
        PunctuationValueCondition dashCondition = new PunctuationValueCondition('/');
        StrengthCondition leftNumTextCondition = new StrengthCondition();
        IntegerCondition rightIntegerCondition = new IntegerCondition();
        WordSetCondition rightNumTextCondition = new WordSetCondition(this.iv_textSuffixSet, false);
        startState.addTransition(leftNumTextCondition, leftNumTextState);
        startState.addTransition(new AnyCondition(), startState);
        leftNumTextState.addTransition(dashCondition, fslashState);
        leftNumTextState.addTransition(new AnyCondition(), startState);
        fslashState.addTransition(rightNumTextCondition, endState);
        fslashState.addTransition(rightIntegerCondition, rightNumTextState);
        fslashState.addTransition(new AnyCondition(), startState);
        rightNumTextState.addTransition(rightNumTextCondition, endState);
        rightNumTextState.addTransition(new AnyCondition(), startState);
        endState.addTransition(new AnyCondition(), startState);
        return m;
    }

    public Set execute(List tokens, Set overrideSet) throws Exception {
        HashSet<SuffixStrengthToken> rangeSet = new HashSet<SuffixStrengthToken>();
        HashMap<Machine, Integer> tokenStartMap = new HashMap<Machine, Integer>();
        Iterator overrideTokenItr = overrideSet.iterator();
        HashMap<Integer, BaseToken> overrideTokenMap = new HashMap<Integer, BaseToken>();
        while (overrideTokenItr.hasNext()) {
            BaseToken t = (BaseToken)overrideTokenItr.next();
            Integer key = new Integer(t.getStartOffset());
            overrideTokenMap.put(key, t);
        }
        boolean overrideOn = false;
        int overrideEndOffset = -1;
        int i = 0;
        while (i < tokens.size()) {
            block9: {
                BaseToken token;
                block10: {
                    Integer key;
                    block8: {
                        token = (BaseToken)tokens.get(i);
                        key = new Integer(token.getStartOffset());
                        if (!overrideOn) break block8;
                        if (token.getStartOffset() < overrideEndOffset) break block9;
                        overrideOn = false;
                        overrideEndOffset = -1;
                        break block10;
                    }
                    if (overrideTokenMap.containsKey(key)) {
                        token = (BaseToken)overrideTokenMap.get(key);
                        overrideOn = true;
                        overrideEndOffset = token.getEndOffset();
                    }
                }
                for (Machine fsm : this.iv_machineSet) {
                    int tokenStartIndex;
                    fsm.input(token);
                    State currentState = fsm.getCurrentState();
                    if (currentState.getStartStateFlag()) {
                        tokenStartMap.put(fsm, new Integer(i));
                    }
                    if (!currentState.getEndStateFlag()) continue;
                    Object o = tokenStartMap.get(fsm);
                    if (o == null) {
                        tokenStartIndex = 0;
                    } else {
                        tokenStartIndex = (Integer)o;
                        ++tokenStartIndex;
                    }
                    BaseToken startToken = (BaseToken)tokens.get(tokenStartIndex);
                    BaseToken endToken = token;
                    SuffixStrengthToken segmentToken = new SuffixStrengthToken(startToken.getStartOffset(), endToken.getEndOffset());
                    rangeSet.add(segmentToken);
                    fsm.reset();
                }
            }
            ++i;
        }
        tokenStartMap.clear();
        for (Machine fsm : this.iv_machineSet) {
            fsm.reset();
        }
        return rangeSet;
    }
}

